{extends file="base.tpl"}

{block name=content}
	<h1>Site Migration</h1>
	
	<form action="/module/load/CMSMigration/migrateSite" method="POST">
		<fieldset>
			<legend><strong>Migrate Subsite</strong></legend>
			<p>Add/Remove subsites by their Subsite ID or their URL.<br/>
			If filename is set, only the filename directly under that location will migrate.<br/>
			Examples: '<code>/</code>', '<code>/ctc/programs/</code>', etc.</p>
				
			<label for='subsite_id' style='display: inline-block; width: 130px; text-align: right; margin-bottom: 1em; font-weight: bold;'>Subsite ID/URL:</label> <input type="text" name="subsite_id" style='width: 300px;' autofocus></input><br/>
			<label for='filename' style='display: inline-block; width: 130px; text-align: right; margin-bottom: 1em; font-weight: bold;'>Filename:</label> <input type="text" name="filename"></input><br/>
			<input type="submit" value="Migrate" />
		</fieldset>
	</form>
		
	
	<h2>Currently migrated sites ({$count})</h2>
	<table>
		<thead>
			<tr>
				<th></th>
				<th>Subsite ID</th>
				<th>Subsite URL</th>
				<th>Filename</th>
			</tr>
		</thead>
		<tbody>
	{foreach $sites as $site}
			<tr>
				<td><a href="/module/load/CMSMigration/unmigrate/{$site->subsite_id}/{$site->filename}"><img src='/images/silk_icons/delete.png' alt='Unmigrate' /></a></td>
				<td>{$site->subsite_id}</td>
				<td><a href="http://www.uaa.alaska.edu{$site->url}">{$site->url}</a></td>
				<td><a href="http://www.uaa.alaska.edu{$site->url}{$site->filename}">{$site->filename}</a></td>
			</tr>
	{/foreach}
		</tbody>
	</table>
{/block}