<?php

class EmailAccounts extends ModuleClass {

	function emailTransfer() {
		$ao = $this->activeObject(ActiveObject::USER);
		
		$this->render('EmailTransfer.tpl');
	}
	
	function isExchangeEnabled() {
		$ao = $this->activeObject(ActiveObject::USER);
		
		//Check for Active Directory homeMDB first
		$homeMDB = $this->ad()->get($ao, array('homeMDB'));
		
		//If not present in AD, check for Federated Exchange Enabled
		if(!$homeMDB || !isset($homeMDB['homeMDB']))
			$homeMDB = (array)$this->federated()->get($ao, array('homeMDB'));
		
		if(count($homeMDB) > 0 && isset($homeMDB['homeMDB'])) return true;
		else return false;
	}
	
	function disableExchange() {
		$ao = $this->activeObject(ActiveObject::USER);
		
		$this->log("Disable Exchange", $ao->id);
	}
	
	function enableExchange() {
		$ao = $this->activeObject(ActiveObject::USER);
		
		$output = array();
		$result = exec("powershell " . MODULE_PATH . get_class() . "\\exenable.ps1 " . $ao->uid, $output);
		
		if($result === "0") {
			$this->log("Enable Exchange", "<a href='$ao->url'>$ao->uid</a>");
			redirect($ao->url);
		}
		else {
			$this->error("Enable Exchange", "<a href='$ao->url'>$ao->uid</a><br/>" . implode("<br/>", $output));
			$this->renderError("Unable to enable Exchange for account.<br/>" . implode("<br/>", $output), $ao->url);
		}
	}
	
	
	function downloadAddressBook() {
		$ao = $this->activeObject(ActiveObject::USER);
		$result = -1;
		$addresses = array();
		
		exec("powershell " . MODULE_PATH . get_class() . "\\sunOnePrintPab.ps1 " . $ao->uid, $addresses, $result);
		
		if(count($addresses) > 0) {
			header("Content-type: application/csv");
			header("Content-Disposition: attachment; filename=" . $ao->uid . ".csv");
			
			foreach($addresses as $address)
				print $address . "\n";
		}
		else {
			$this->renderError("User account has no addresses in their address book.", $ao->url);
		}
	}

	
	function webmailToGmail() {
		$ao = $this->activeObject(ActiveObject::USER);
		$uid = $ao->uid;
		
		$imapPass = $this->ensurePassword($ao);
		if(!$imapPass) return;
		
		//$source = "imap.uaa.alaska.edu:143/$uid/$imapPass"; 
		$dest = "imap.gmail.com:993/$uid@alaska.edu/$imapPass";

		$this->performCopy($uid, $source, $dest);
	}
	
	function webmailToExchange() {
		$ao = $this->activeObject(ActiveObject::USER);
		$uid = $ao->uid;
		
		$imapPass = $this->ensurePassword($ao);
		if(!$imapPass) return;
		
		//$source = "imap.uaa.alaska.edu:143/$uid/$imapPass"; 
		//$dest = "imap.gmail.com:993/$uid@alaska.edu/$imapPass";
		
		$this->performCopy($uid, $source, $dest);
	}
	
	function exchangeToGmail() {
		$ao = $this->activeObject(ActiveObject::USER);
		$uid = $ao->uid;
		
		$imapPass = $this->ensurePassword($ao);
		if(!$imapPass) return;
		
		$source = "imap.uaa.alaska.edu:143/$uid/$imapPass"; 
		$dest = "imap.gmail.com:993/$uid@alaska.edu/$imapPass";
		
		$this->performCopy($uid, $source, $dest);
	}
	
	function gmailToExchange() {
		$ao = $this->activeObject(ActiveObject::USER);
		$uid = $ao->uid;
		
		$imapPass = $this->ensurePassword($ao);
		if(!$imapPass) return;
		
		$source = "imap.gmail.com:993/$uid@alaska.edu/$imapPass";
		$dest = "imap.uaa.alaska.edu:143/$uid/$imapPass"; 
		
		$this->performCopy($uid, $source, $dest);
	}
	
	private function ensurePassword(ActiveObject $ao) {
		$passwords = $this->module('Passwords');
		$imapPass = $passwords->getSunOnePassword($ao->uid);
		
		if(!$imapPass) {
			$this->renderDefault(array('content' => "<p>Could not authenticate as user. Do they have a default password set?</p> <a class='button' href='/module/load/" . get_class() . "/'>Return</a>"));
			return false;
		}
		
		return $imapPass;
	}
	
	private function performCopy($uid, $source, $dest) {
		exec("psexec -d -accepteula perl.exe " . MODULE_PATH . get_class() . "\\imapcopy.pl -d -q -L C:\\gmail_logs\\" . $uid . "-log.txt  -S " . $source . " -D " . $dest);
	}
}


?>