﻿#
# GrabMyPAB.ps1 - Address Book migration tool for the Gmail project
# j03 @ ITS 2010		
#
# dep: novell.directory.ldap.dll
#

#ldap bind strings and lib load
[Reflection.Assembly]::LoadFile("c:\windows\system32\novell.directory.ldap.dll") | Out-Null

$SUNUSER = "cn=Directory Manager"
$SUNPASS = ""
$SUNLDAP = "sentry.uaa.alaska.edu"

$STUDENT = "ou=student,o=uaa.alaska.edu,o=isp"
$PAB = "ou=student,o=uaa.alaska.edu,o=isp,o=pab"

$uid = $args[0]
if ($uid -eq $null)	{
	""
	"Usage: GrabMyPAB.ps1 <username>"
	""
	exit
}

#bind to ldap and search for user object
$ldap = New-Object Novell.Directory.Ldap.LdapConnection
$ldap.connect("sentry.uaa.alaska.edu", "389")
$ldap.bind($SUNUSER, $SUNPASS)

#get the users DN
$filter = "(&(objectclass=inetorgperson)(uid=$uid))"
$attrs = [Novell.Directory.Ldap.LdapConnection]::No_Attrs
$scope = [Novell.Directory.Ldap.LdapConnection]::Scope_One

$results = $ldap.Search($STUDENT, $scope, $filter, $attrs, $true)
	
while ($results.hasMore())	{
	$ldapUserDn = $results.next().dn
}
	
$pabPath = $ldap.read($ldapUserDn).getAttribute("pabURI").stringValue
	
if ($pabPath)	{
	#strip the 'ldap://sentry.uaa.alaska.edu:389/' off the beginning of the string 
	$pabDn = $pabPath.split('/')[3]
	
	#now fire up the searcher again to query for children in pab hierarchy
	$filter = "(objectclass=pabperson)"
	#$attrs = [Novell.Directory.Ldap.LdapConnection]::No_Attrs
	#$scope = [Novell.Directory.Ldap.LdapConnection]::Scope_One
	$results = $ldap.Search($pabDn, $scope, $filter, $attrs, $true)
	
	$pabEntries = @()
	while ($results.hasMore())	{
		$pabEntries+= $results.next().dn
	}
	
	$csvList+= "Name,E-mail Address,Notes,Business Phone,Home Phone,Mobile Phone`n"
	foreach ($pabEntry in $pabEntries)	{
		$contactName = $ldap.read($pabEntry).getAttribute("cn").stringValue
		$contactEmail = $ldap.read($pabEntry).getAttribute("mail").stringValue
		$contactWorkphone = $ldap.read($pabEntry).getAttribute("telephoneNumber").stringValue
		$contactHomePhone = $ldap.read($pabEntry).getAttribute("homePhone").stringValue
		$contactMobile = $ldap.read($pabEntry).getAttribute("mobile").stringValue
		$csvList+= "$contactName,$contactEmail,webmail contact,$contactWorkphone,$contactHomePhone,$contactMobile`n"
	}
	
	
	
	# print string
	$csvList
	
	
	$ldap.disconnect()	

	
	#copy the string into a memory stream so it can be turned into a file without writing to disk
	#$stream = New-Object System.IO.MemoryStream
	#for ($i = 0; $i -lt $csvlist.length; $i++)	{
	#	$stream.writebyte([byte] $csvList[$i])
	#}
	#$stream.position = 0

	#email the user
	#$sender = "axcallcenter@uaa.alaska.edu"
	#$recipient = "$uid@alaska.edu"
	#$server = "aspam-out.uaa.alaska.edu"
	#$file = "c:\addressBook.csv"

	#$subject = "Webmail Address Book export"
	#$body = "Your Webmail Address Book has been exported as a csv attachment to this email. If you need assistance importing your address book check out <a href='http://mail.google.com/support/bin/answer.py?hl=en&answer=14024'>this Google article</a>."
	#$msg = New-Object System.Net.Mail.MailMessage($sender, $recipient, $subject, $body)
	#$msg.IsBodyHTML = $true
	#$attachment = New-Object System.Net.Mail.Attachment($stream, "addressBook.txt")
	#$msg.Attachments.Add($attachment)
	#$client = New-Object System.Net.Mail.SmtpClient $server

	#$client.Send($msg)		

	#killing time :)
	#$stream.dispose()
}

