<?php

class ForwardingAddresses extends ModuleClass {

	/**
	 * Displays all forwarding addresses for the current Active Object.
	 **/
	public function index() {
		$ao = $this->activeObject(ActiveObject::USER);
		
		$alternate = $this->sunone()->get($ao, array('sn', 'mailforwardingaddress'));
		
		if(isset($alternate['mailforwardingaddress'])) $alternate = $alternate['mailforwardingaddress'];
		else $alternate = array();
		
		sort($alternate);
		
		$this->render('forwardingAddresses.tpl', array('forwardingaddresses' => $alternate));
	}
	
	/**
	 * Adds a SunOne-based forwarding address for the current Active Object
	 **/
	public function newAddress() {
		try {
			//Validate the new alias
			$address = $_REQUEST['newAddress'];
			if(!isset($address) || !preg_match('/[a-zA-Z0-9._%-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4}/', $address)) throw new Exception('Invalid e-mail for forwarding address.');
			
			$ao = $this->activeObject(ActiveObject::USER);
			$user = $this->sunone()->get($ao, array("mailforwardingaddress"));
			
			//Validate account and new address against LDAP
			if(!$user)
				throw new Exception('User account could not be located.');
			elseif(isset($user['mailforwardingaddress']) && in_array($address, $user['mailforwardingaddress']))
				throw new Exception('This address has already been set for the account.');
		
			//Perform add and verify address has been added
			if($user) $sunResult = $this->sunone()->add($user['dn'], array('mailforwardingaddress' => $address));
			
			$this->log('Add Forwarding Address', $ao->uid . ' - ' . $address);
			redirect('/module/load/' . get_class());
		}
		catch(Exception $e) {
			$this->error('Add Forwarding Address', $e->getMessage());
			return $this->renderError(null, "/module/load/" . get_class(), $e);
		}
	}
	
	
	/**
	 * Removes a SunOne-based forwarding address for the current Active Object
	 **/
	public function removeAddress($params) {
		try {
			$address = $params[0];
			$ao = $this->activeObject(ActiveObject::USER);
			$user = $this->sunone()->get($ao, array());

			//Validate account
			if(!$user) throw new Exception('User account could not be located.');
		
			//Perform remove
			if($user) $sunResult = $this->sunone()->remove($user['dn'], array('mailforwardingaddress' => $address));
			
			$this->log('Remove Forwarding Address', $ao->uid . ' - ' . $address);
			redirect('/module/load/' . get_class());
		}
		catch(Exception $e) {
			$this->error('Remove Forwarding Address', $e->getMessage());
			return $this->renderError(null, "/module/load/" . get_class(), $e);
		}
	}
	
	
}


?>