$(function() {

	/******
	 * Replace all loading classes with their target content
	 ******/
	$('.loading').each(function() {
		$(this).load($('.target', this).val(), function(str) {
			$(this).removeClass('loading');
			
			//Fixing odd jQuery bug where innerHTML is sometimes not updated
			//if(this.innerHTML.length == 0 && str.length > 0) this.innerHTML = str;
		});
	});
	
	/******
	 * Set loading_bool classes to their target values
	 ******/
	$('.loading_bool').each(function() {
		var obj = this;
		
		$.get($('.target', this).val(), function(str) {
			tmp = parseInt(str);
			if(tmp == 1) $(obj).addClass('checked');
			else if(tmp == 0) ;
			else {
				$(obj).addClass('unknown').css('cursor', 'pointer');
				
				dialogOptions = {};
				dialogOptions.modal = true;
				dialogOptions.buttons = {
					Ok: function() {
						$( this ).dialog( "close" );
					}
				};
				
				$(obj).click(function() { $("<div>").html(str.slice(0, -1)).dialog(dialogOptions); });
			}
			
			$(obj).removeClass('loading_bool');
		});
	});
		
	
	/******
	 * Set click-to-fade on all fade elements
	 ******/
	$('.fade').click(function () { $(this).fadeOut('slow'); });
});