/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.activities;

import org.me.sealproject.controllers.activitycontrollers.SealActivityController;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.*;
import org.me.sealproject.SealLogger;

/**
 * Base for all Seal Activities. Handles menu creation when options button is clicked.
 * Seal Activities should exclusively manage visual resources. They should be provide a usable interface for getting and setting values into the
 * user interface as appropriate for the SealActivity controller to use.
 *
 * Because of Android's natural activity management setup, the controller is initialized from the activity. By default, this is called in the "OnCreate" method.
 * The design principle is that the controller will handle all button calls and logic. This implies that the callback functions must be manually applied. Those applied through
 * XML are discouraged in order to promote consistency.
 *
 * @author samuelgbeecher
 */
public abstract class SealActivity extends Activity implements SealLogger {
    public static final String DEBUG = "ACTIVITY DEBUG";

    protected SealActivityController controller;

    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        initController();       
    }

    @Override
    public void onStart(){
        super.onStart();
        controller.onStart();
    }

    @Override
    public void onPause(){
        super.onPause();
        controller.onPause();
    }

    @Override
    public void onRestart(){
        super.onRestart();
        controller.onRestart();
    }

    @Override
    public void onStop(){
        super.onStop();
        controller.onStop();
    }

    @Override
    public void onDestroy(){
        super.onDestroy();
        controller.onDestroy();
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data){
        LOG("Activity Result: Result Code = " + resultCode + " Request Code = " + requestCode);

        super.onActivityResult(requestCode, resultCode, data);
        controller.onActivityResult(requestCode, resultCode, data);
    }

    /**
     * Each SealActivity must have a corresponding SealActivityController. By default, the on create method initializes this controller.
     */
    protected abstract void initController();

     @Override
     public boolean onCreateOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);

        //These intents tell the manager to check if activity is in stack already, if so, to bring it to front before starting a new one. 
        Intent loginIntent = new Intent(this, SealLoginActivity.class);
        loginIntent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
        loginIntent.addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP);
        
//        Intent observationIntent = new Intent(this, SealObservationActivity.class);
//        observationIntent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
//        observationIntent.addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP);
//
//        Intent countIntent = new Intent(this, SealCountActivity.class);
//        countIntent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
//        countIntent.addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP);

        menu.add("Change Login").setIcon(android.R.drawable.ic_menu_edit).setIntent(loginIntent);
//        menu.add("Observations").setIcon(android.R.drawable.ic_menu_edit).setIntent(observationIntent);
//        menu.add("Counts").setIcon(android.R.drawable.ic_menu_edit).setIntent(countIntent);

        return true;
    }

     public void LOG(String message){
         if(debug){
             Log.d(DEBUG, message);
         }
     }



}
