/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.activities;


import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.View;
import android.widget.*;

import org.me.sealproject.*;
import org.me.sealproject.controllers.activitycontrollers.SealCountActivityController;
import org.me.sealproject.controllers.activitycontrollers.SealLookupActivityController;
import org.me.sealproject.customwidgets.DefaultSpinner;
import org.me.sealproject.customwidgets.Counter;
//import org.me.sealproject.sealdatatypes.SealCount;
import org.me.sealproject.sealdatatypes.*;


/**
 *
 * @author samuelgbeecher
 */
public class SealCountActivity extends SealActivity {

    private Counter liveLoneBull, liveTerrBull, liveHaremBull, liveFemale, livePup;
    private Counter deadNonadolescent, deadBull, deadFemale, deadPup;

    private TextView observer, island, rookery, countHeader;
    private DefaultSpinner section;

    @Override
    protected void initController() {
        controller = new SealCountActivityController(this);
    }

    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle icicle) {
        setContentView(R.layout.count_entry_form);

        observer = (TextView)findViewById(R.id.count_observer_text);
        island = (TextView)findViewById(R.id.count_island_text);
        rookery = (TextView)findViewById(R.id.count_rookery_text);
        section = (DefaultSpinner)findViewById(R.id.count_section_spinner);
        countHeader = (TextView)findViewById(R.id.count_header_text);

        liveLoneBull = (Counter)findViewById(R.id.count_live_lonebull_counter);
        liveTerrBull = (Counter)findViewById(R.id.count_live_terrbull_counter);
        liveHaremBull = (Counter)findViewById(R.id.count_live_harembull_counter);
        liveHaremBull.setMaxCount(1);

        liveFemale = (Counter)findViewById(R.id.count_live_female_counter);
        livePup = (Counter)findViewById(R.id.count_live_pup_counter);

        deadNonadolescent = (Counter)findViewById(R.id.count_dead_nonadolescent_counter);
        deadBull = (Counter)findViewById(R.id.count_dead_bull_counter);
        deadFemale = (Counter)findViewById(R.id.count_dead_female_counter);
        deadPup = (Counter)findViewById(R.id.count_dead_pup_counter);

        super.onCreate(icicle);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);

        Intent countIntent = new Intent(this, SealLookupActivity.class);
        countIntent.putExtra(SealLookupActivityController.REQUEST_CODE, SealLookupActivityController.REQUEST_CODE_COUNT);
        countIntent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
        countIntent.addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP);

        menu.add("Previous Counts").setIcon(android.R.drawable.ic_menu_edit).setIntent(countIntent);

        return true;
    }

    public void clearCountDisplay(){
      liveLoneBull.clear();
      liveTerrBull.clear();
      liveHaremBull.clear();
      liveFemale.clear();
      livePup.clear();
      
      deadNonadolescent.clear();
      deadBull.clear();
      deadFemale.clear();
      deadPup.clear();
    }

    public void onLiveCount(View view){
        findViewById(R.id.count_dead_row).setVisibility(View.GONE);
        findViewById(R.id.count_live_row).setVisibility(View.VISIBLE);
    }

    public void onDeadCount(View view){
        findViewById(R.id.count_dead_row).setVisibility(View.VISIBLE);
        findViewById(R.id.count_live_row).setVisibility(View.GONE);
    }

    public SealCount getSealCount(){
        SealCount count = new SealCount();

        count.setLiveLoneBullCount(liveLoneBull.getCount());
        count.setLiveTerrBullCount(liveTerrBull.getCount());
        count.setLiveHaremBullCount(liveHaremBull.getCount());
        count.setLiveFemaleCount(liveFemale.getCount());
        count.setLivePupCount(livePup.getCount());
        
        count.setDeadNonAdolescentCount(deadNonadolescent.getCount());
        count.setDeadBullCount(deadBull.getCount());
        count.setDeadFemaleCount(deadFemale.getCount());
        count.setDeadPupCount(deadPup.getCount());

        return count;
    }

    public String getObserver(){
        return observer.getText().toString();
    }

    public void setObserver(String observer){
        this.observer.setText(observer);
    }

    public String getRookery(){
        return this.rookery.getText().toString();
    }

    public void setRookery(String rookery){
        this.rookery.setText(rookery);
    }

    /**
     * @return the island
     */
    public String getIsland() {
        return island.getText().toString();
    }

    /**
     * @param island the island to set
     */
    public void setIsland(String island) {
        this.island.setText(island);
    }

    /**
     * @return the section
     */
    public String getSection() {
        return section.getSelectedItem();
    }

    /**
     * @param section the section to set
     */
    public void setSection(String newSection) {
        section.setSelection(newSection);
    }

    public void setCountHeader(String newHeader){
        countHeader.setText(newHeader);
    }
}
