/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.controllers.activitycontrollers;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.view.View;

import org.me.sealproject.controllers.datacontrollers.SealDataController;
import org.me.sealproject.activities.*;
import org.me.sealproject.*;
import org.me.sealproject.controllers.SealController;

/**
 * Base for all activity controllers
 * @author samuelgbeecher
 */

public abstract class SealActivityController extends SealController {
    protected SealDataController dataController;
    protected SealActivity activity;
    protected SharedPreferences preferences;

    protected SealActivityController(SealActivity act){
        super(act.getApplication());
        
        dataController = SealDataController.getSharedInstance(act.getApplication());
        activity = act;
        preferences = act.getSharedPreferences(act.getResources().getString(R.string.preferences_file_name), 0);
    }

    /* Override these */
    public void onStart(){

    }

    public void onPause(){

    }

    public void onRestart(){

    }

    public void onStop(){

    }

    public void onDestroy(){
        
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data){
        
    }

    public Intent getActivityIntent(){
        return activity.getIntent();
    }

     /**
     * Display the given Error message and put focus on the given resource.
     */
    protected void displayErrorMessage(String message, int resourceId, boolean focusOnResource){
        TOAST_USER(message, activity);
        if(focusOnResource){
            focusOnResource(resourceId);
        }
    }

    protected void displayConfirmationDialog(String message, int resourceId, boolean focusOnResource){
         AlertDialog.Builder builder = new AlertDialog.Builder(activity);
         builder.setMessage(message)
           .setCancelable(false)
           .setPositiveButton("OK", new DialogInterface.OnClickListener() {
               public void onClick(DialogInterface dialog, int id) {
                   confirmationDialogClosed();
                   dialog.dismiss();
               }
           });
         

         AlertDialog alert = builder.create();

         alert.show();
           
    }

    protected void confirmationDialogClosed(){

    }

    private void focusOnResource(int resourceId){
        View v = activity.findViewById(resourceId);
        if(v != null){
            v.setFocusableInTouchMode(true);
            v.requestFocus();
        }
    }
}
