/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.controllers.activitycontrollers;

import android.content.Intent;
import android.view.View;
import android.view.View.OnClickListener;

import java.util.ArrayList;

import org.me.sealproject.activities.*;
import org.me.sealproject.*;
import org.me.sealproject.customwidgets.DefaultSpinner;
import org.me.sealproject.sealdatatypes.SealCount;
import org.me.sealproject.sealdatatypes.SealIsland;

/**
 *
 * @author samuelgbeecher
 */
public class SealCountActivityController extends SealActivityController{
    
    private String observer;
    private String islandName;
    private String rookeryName;
    private long startTime;

    public SealCountActivityController(SealCountActivity act){
        super(act);
    }

    @Override
    public void onStart(){
        if(loadPreferences()){
            setupRookerySections();
            setStartTime(TIME());
        }
        else{
            TOAST_USER("Must Login", activity);
            activity.startActivity(new Intent(activity, SealLoginActivity.class));
        }

        setupListeners();
    }

    private boolean loadPreferences(){
        if(preferences.contains(activity.getResources().getString(R.string.preference_key_observer))){
            observer = preferences.getString(activity.getResources().getString(R.string.preference_key_observer), "");
            islandName = preferences.getString(activity.getResources().getString(R.string.preference_key_island), "");
            rookeryName = preferences.getString(activity.getResources().getString(R.string.preference_key_rookery), "");

            ((SealCountActivity)activity).setIsland(islandName);
            ((SealCountActivity)activity).setRookery(rookeryName);
            ((SealCountActivity)activity).setObserver(observer);

            return true;
        }
        else{
            return false;
        }
    }

    private void setupListeners(){
         activity.findViewById(R.id.count_live_submit_button).setOnClickListener(new OnCountSubmitListener());
         activity.findViewById(R.id.count_dead_submit_button).setOnClickListener(new OnCountSubmitListener());
    }

    private void setupRookerySections(){
        ArrayList<SealIsland> islands = dataController.getIslands();

        if(islands != null){
            SealIsland currentIsland = null;
            for(SealIsland island : islands){

                if(island.getName().equalsIgnoreCase(islandName)){
                    currentIsland = island;
                    break;
                }
            }

            ArrayList<String> sections = currentIsland.getSections(rookeryName);

            DefaultSpinner sectionSpinner = (DefaultSpinner)activity.findViewById(R.id.count_section_spinner);
            sectionSpinner.setSelectionList(new ArrayList<String>(sections));
        }
    }
    
    public boolean isFormValid(SealCount count){
        boolean valid = false;

        if(count.getRookerySection() == null){
            displayErrorMessage("Must Select A Section",  R.id.count_section_spinner, true);
        }
        else if(count.getLiveHaremBullCount() > 0 && count.getLiveFemaleCount() <= 0){
            displayErrorMessage("Harem Bulls Must Have Females",  R.id.count_live_harembull_counter, true);
        }
        else if(count.isEmpty()){
            displayErrorMessage("Must Enter Count Information",  -1, false);
        }
        else{
            valid = true;
        }
        
        return valid;
    }

    /**
     * @return the startTime
     */
    public long getStartTime() {
        return startTime;
    }

    /**
     * @param startTimeIn the startTime to set
     */
    public void setStartTime(long startTimeIn) {
        startTime = startTimeIn;
    }

    class OnCountSubmitListener implements OnClickListener{
        public void onClick(View clickedView) {
            SealCount count = ((SealCountActivity)activity).getSealCount();

            count.setObserver(observer);
            count.setIsland(islandName);
            count.setRookery(rookeryName);
            count.setRookerySection(((SealCountActivity)activity).getSection());
            count.setStartEntryTime(getStartTime());
            count.setEndEntryTime(TIME());

            if(!isFormValid(count)){
                return;
            }

            dataController.getDatabaseController().openOrCreateDatabase();

            boolean inserted = dataController.getDatabaseController().insertCount(count);
            
            dataController.getDatabaseController().close();

            if(inserted){
              

               setStartTime(TIME());

               TOAST_USER("Count Submitted For Section " + ((SealCountActivity)activity).getSection(), activity);
               LOG("Count Submitted");
               
               ((SealCountActivity)activity).clearCountDisplay();
            }

        }

    }


}
