/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.controllers.activitycontrollers;

import android.content.SharedPreferences;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.*;
import android.widget.AdapterView.OnItemSelectedListener;

import java.util.ArrayList;

import org.me.sealproject.activities.*;
import org.me.sealproject.customwidgets.*;
import org.me.sealproject.sealdatatypes.*;
import org.me.sealproject.*;

/**
 *
 * @author samuelgbeecher
 */
public class SealLoginActivityController extends SealActivityController {
    
    private SealLoginActivity activity;

    public SealLoginActivityController(SealLoginActivity act){
        super(act);
        activity = act;
    }

    @Override
    public void onStart(){
        if(preferences.contains(activity.getResources().getString(R.string.preference_key_observer))){
            String observer = preferences.getString(activity.getResources().getString(R.string.preference_key_observer), "");
            String island = preferences.getString(activity.getResources().getString(R.string.preference_key_island), "");
            String rookery = preferences.getString(activity.getResources().getString(R.string.preference_key_rookery), "");

            (activity).setObserver(observer);
            (activity).setRookery(rookery);
            (activity).setIsland(island);
        }

        DefaultSpinner islandSpinner = (DefaultSpinner)activity.findViewById(R.id.login_island_spinner);
        setupIslands(islandSpinner);
        
        activity.findViewById(R.id.login_button).setOnClickListener(new OnLoginClicked());
    }

    private void setupIslands(DefaultSpinner islandSpinner){
        ArrayList<SealIsland> islands = dataController.getIslands();
        ArrayList<String> islandNames = new ArrayList<String>();

        if(islands != null){
            for(SealIsland island : islands){
                islandNames.add(island.getName());
            }

            islandSpinner.setSelectionList(islandNames);
            islandSpinner.setOnItemSelectedListener(new onIslandClicked());
             activity.findViewById(R.id.login_rookery_spinner).setEnabled(false);
        }
    }

    public boolean validateForm(String observer, String island, String rookery){
        if(observer == null || observer.length() < 2){
            displayErrorMessage("Must Enter Observer", R.id.login_observer_edittext, true);
            return false;
        }
        else if(island == null)
        {
            displayErrorMessage("Must Select an Island", R.id.login_island_spinner, true);

            return false;
        }
        else if(rookery == null){
            displayErrorMessage("Must Select a rookery", R.id.login_rookery_spinner, true);
            return false;
        }
        else{
            return true;
        }

    }

    class onIslandClicked implements OnItemSelectedListener{

        public void onItemSelected(AdapterView<?> adapterView, View viewClicked, int index, long id) {
            DefaultSpinner spinner = (DefaultSpinner)adapterView;
            DefaultSpinner rookerySpinner = (DefaultSpinner)activity.findViewById(R.id.login_rookery_spinner);

            int ind = spinner.getSelectedItemPositionIgnoringDefault();
            LOG(ind + " is the selection Index");

            String selection = spinner.getSelectedItem();

            if(selection != null){
                LOG(selection +" was selected");
                ArrayList<SealIsland> islands = dataController.getIslands();

                SealIsland selectedIsland = null;
                for(SealIsland island : islands){
                    if(island.getName().equalsIgnoreCase(selection)){
                        LOG("Island found");
                        selectedIsland = island;
                        break;
                    }
                }
                
                if(selectedIsland != null){
                    ArrayList<String> rookeries = selectedIsland.getRookeries();
                    LOG("Getting Rookeries");
                    if(rookeries != null){
                        LOG("Setting Rookeries");
                        rookerySpinner.setSelectionList(rookeries);
                    }
                }

                // No matter what, if an item is selected, enable the spinner
                rookerySpinner.setEnabled(true);
            }
            else{
                rookerySpinner.setEnabled(false);
            }
        }

        public void onNothingSelected(AdapterView<?> arg0) {

        }

    }

    class OnLoginClicked implements OnClickListener{
        public void onClick(View arg0) {
             SharedPreferences settings = activity.getSharedPreferences(activity.getResources().getString(R.string.preferences_file_name), 0);
            SharedPreferences.Editor prefEditor = settings.edit();

            String observer, rookery, island;
            observer = activity.getObserver();
            island = activity.getIsland();
            rookery = activity.getRookery();

            if(!validateForm(observer, island, rookery)){
                return;
            }

            prefEditor.putString(activity.getResources().getString(R.string.preference_key_observer), observer);
            prefEditor.putString(activity.getResources().getString(R.string.preference_key_island), island);
            prefEditor.putString(activity.getResources().getString(R.string.preference_key_rookery), rookery);
            prefEditor.commit();

           TOAST_USER("Logged In", activity);

            activity.finish();
        }
    }


}
