/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.controllers.activitycontrollers;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.DatePickerDialog;

import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.view.LayoutInflater;

import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.Button;
import android.widget.DatePicker;

import java.util.Calendar;
import java.util.Date;

import org.me.sealproject.R;
import org.me.sealproject.activities.*;
import org.me.sealproject.customwidgets.CustomDatePickerDialogAdapter;
import org.me.sealproject.customwidgets.CustomDatePickerDialogAdapter.OnDatePickedListener;

/**
 * @author samuelgbeecher
 */
public class SealMainMenuActivityController extends SealActivityController {

    public SealMainMenuActivityController(SealMainMenuActivity act){
        super(act);
    }

    @Override
    public void onStart(){
        
        SharedPreferences settings = activity.getSharedPreferences(activity.getResources().getString(R.string.preferences_file_name), 0);

        ((AdapterView)activity.findViewById(R.id.main_menu_list)).setOnItemClickListener(new OnMenuItemClickListener());

        final Activity myActivity = activity;

        if(!settings.contains(activity.getResources().getString(R.string.preference_key_observer))){
            AlertDialog.Builder builder = new AlertDialog.Builder(activity);
            builder.setMessage("You have not logged in.")
           .setCancelable(false)
           .setPositiveButton("Login", new DialogInterface.OnClickListener() {
               public void onClick(DialogInterface dialog, int id) {
                   activity.startActivity(new Intent(myActivity, SealLoginActivity.class));
                   dialog.dismiss();
               }
           })
           .setNegativeButton("Exit", new DialogInterface.OnClickListener() {
               public void onClick(DialogInterface dialog, int id) {
                    myActivity.finish();
               }
           });
           AlertDialog alert = builder.create();
           alert.show();
        }
    }


    private void startDatePicker(){
        CustomDatePickerDialogAdapter dialog = new CustomDatePickerDialogAdapter(activity);

        dialog.setOnDatePickedListener(new OnDatePickedListener(){

            public void onDatePicked(DatePicker picker, int year, int month, int day) {

                Calendar cal = Calendar.getInstance();
                cal.set(year, month, day);
                exportCSV(cal);
            }

        });


        AlertDialog myDialog = dialog.getDialog();
        myDialog.show();
    }

    private void exportCSV(Calendar cal)
    {
        boolean successful = dataController.exportCSV(TIME());

        if(!successful)
        {
            super.displayConfirmationDialog(cal.get(Calendar.MONTH) + "/" + cal.get(Calendar.DAY_OF_MONTH) + "/" + cal.get(Calendar.YEAR) + "\nCSV Export Failed. Is Media Mounted Correctly?", 0, false);
        }
        else
        {
            super.displayConfirmationDialog(cal.get(Calendar.MONTH) + "/" + cal.get(Calendar.DAY_OF_MONTH) + "/" + cal.get(Calendar.YEAR) + "\nCSV Export Successful!!", 0, false);
        }
    }

    class OnMenuItemClickListener implements OnItemClickListener{
        public void onItemClick(AdapterView<?> arg0, View arg1, int position, long arg3)
        {
            switch(position)
            {
                case 0: // Observations
                    activity.startActivity(new Intent(activity, SealObservationActivity.class));
                    TOAST_USER("Observation Entry Form", activity);
                    break;
                case 1: // Counts
                    activity.startActivity(new Intent(activity, SealCountActivity.class));
                    TOAST_USER("Count Entry Form", activity);
                    break;
                case 2: // Export
                    startDatePicker();
                   
                    //handle export
                    break;
                default:
                    break;
            }
        }

    }
}
