/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.controllers.activitycontrollers;

import android.app.ProgressDialog;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.*;

import java.util.ArrayList;

import org.me.sealproject.R;
import org.me.sealproject.SealLogger;
import org.me.sealproject.activities.*;
import org.me.sealproject.controllers.datacontrollers.*;
import org.me.sealproject.sealdatatypes.*;

/**
 *
 * @author samuelgbeecher
 */
public class SealStartupActivityController extends SealActivityController implements SealLogger{

    private boolean finish = false;
    private ProgressDialog dialog;

    public SealStartupActivityController(SealStartupActivity act){
        super(act);

        //WARNING: Database NOT being deleted
        //LOG("Database Being Deleted");
        //act.deleteDatabase(SealDatabaseController.DATABASE_NAME);

        if(debug){
            TOAST_DEBUG("DEBUGGING APPLICATION");
            loadTestData();
        }
        else{
            SharedPreferences.Editor prefEditor = preferences.edit();
            prefEditor.remove(activity.getResources().getString(R.string.preference_key_observer));
            prefEditor.remove(activity.getResources().getString(R.string.preference_key_island));
            prefEditor.remove(activity.getResources().getString(R.string.preference_key_rookery));
            prefEditor.commit();
        }
    }

    public void loadTestData(){
        Seal seal = new Seal();
        seal.setId("MSP0361");
        seal.setSex("Male");

        SealTag tag = new SealTag();
        tag.setType("M");
        tag.setNumber("SP0361");
        tag.setSide("R");
        seal.setFirstTag(tag);

        tag = new SealTag();
        tag.setType("AN");
        tag.setNumber("120");
        tag.setColor("Pink");
        tag.setSide("Right");
        seal.setSecondTag(tag);

        dataController.getDatabaseController().openOrCreateDatabase();
        dataController.getDatabaseController().insertOrUpdateSealAndTags(seal);
        dataController.getDatabaseController().close();
    }

    @Override
    public void onStart(){

        if(!finish){
            dialog = ProgressDialog.show(activity, "",
                            "Loading. Please wait...", true, false);


            SyncData sd = new SyncData(dialog);

            sd.start();
            
            finish = true;
        }
        else{
           activity.finish();
        }

    }

    //TODO: Move sync data to Data Controller
    private class SyncData extends Thread{
        ProgressDialog d;

        public SyncData(ProgressDialog dialog){
            d = dialog;
        }

        @Override
        public void run(){
            Looper.prepare();
            LOG("LOADING FILE");
            ArrayList<Seal> xml = (ArrayList<Seal>)dataController.loadXmlAsArrayList(SealDataController.SEALS_XML_FILE_NAME);

            if(xml == null){
                LOG("No upload. Media not mounted?");
            }
            else {
                LOG("Data valid. Uploading to DB");

                SealDatabaseController databaseController = dataController.getDatabaseController();

                databaseController.openOrCreateDatabase();

                try{
                    databaseController.clearTagRecords();
                    LOG("Tags Deleted");
                }
                catch(Exception e){
                    ERROR("Error Deleting Tags", e);
                }

                try{
                    databaseController.clearSealRecords();
                    LOG("Seals Deleted");
                }
                catch(Exception e){
                    ERROR("Error Deleting Seal Tags", e);
                }
                
                databaseController.insertMultipleSealAndTags(xml);
                databaseController.close();

                dataController.deleteXmlFile(SealDataController.SEALS_XML_FILE_NAME);
            }

           handler.sendEmptyMessage(0);
        }
        
        private Handler handler = new Handler() {

            @Override
            public void handleMessage(Message msg) {
                d.dismiss();
                
                LOG("Finishing Activity");
                activity.startActivity(new Intent(activity.getApplication(), SealMainMenuActivity.class));
                activity.finish();
            }
        };
    }

}
