/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.controllers.datacontrollers;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabase.CursorFactory;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;

import org.me.sealproject.database.*;

/**
 *
 * @author samuelgbeecher
 */
public class SealDatabaseHelper extends SQLiteOpenHelper {
    public static final String DEBUG = "OPENHELPER DEBUG";
   
    public SealDatabaseHelper(Context context, String name, CursorFactory factory, int version){
        super(context, name, factory, version);
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        if(db.isOpen()){
            db.beginTransaction();

            try{
                db.execSQL(Counts.CREATE_COUNT_TABLE);
                db.execSQL(Seals.CREATE_SEAL_TABLE);
                db.execSQL(Tags.CREATE_TAG_TABLE);
                db.execSQL(Observations.CREATE_OBSERVATION_TABLE);

                db.execSQL(Seals.CREATE_TRIGGER_DELETE);
                db.execSQL(Seals.CREATE_TRIGGER_UPDATE);

                db.execSQL(Tags.CREATE_TRIGGER_ADD);
                //db.execSQL(Tags.CREATE_TRIGGER_DELETE);
                db.execSQL(Tags.CREATE_TRIGGER_UPDATE);

                db.setTransactionSuccessful();
            }
            catch (Exception e){
                Log.e(DEBUG, "Error Creating Database", e);
            }
            finally{
                db.endTransaction();
            }
        }

    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {

    }
}
