/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.controllers.datacontrollers;


import android.content.Context;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import org.me.sealproject.controllers.SealController;
import org.me.sealproject.controllers.datacontrollers.xmlhandler.*;
import org.me.sealproject.sealdatatypes.*;

/**
 *
 * @author samuelgbeecher
 */
public class SealXmlController extends SealController{

    private SealParser parser;

    public SealXmlController(Context context){
        super(context);

        parser = new SealXmlParser();
    }

    /**
     * Parse the seal id xml. Given file must point to correctly XML file.
     * @param file - file to be parsed.
     * @param isAppFile - if true, file location is internal memory. If false, file location is external memory (SD)
     * @return ArrayList of all parsed seals
     */
    public ArrayList<Seal> parseSealXml(String file, boolean isAppFile){

       ArrayList sealData = new ArrayList();

        HashMap map = parseXml(file, isAppFile, new SealIDHandler());

        if(map != null){
            for(Iterator itr = map.values().iterator(); itr.hasNext(); ){
                Seal seal = (Seal)itr.next();
                sealData.add(seal);
            }
        }

        if(sealData.isEmpty())
            return null;

       return sealData;
    }

    /**
     * Parse the Island, Rookery and Section xml. Given file must point to correctly XML file.
     * @param file - file to be parsed.
     * @param isAppFile - if true, file location is internal memory. If false, file location is external memory (SD)
     * @return ArrayList of all parsed islands
     */
    public ArrayList<SealIsland> parseIslandXml(String file, boolean isAppFile){
        ArrayList sealData = new ArrayList();

        HashMap map = parseXml(file, isAppFile, new SealIslandHandler());

        if(map != null){
            for(Iterator itr = map.values().iterator(); itr.hasNext(); ){
                sealData.add(itr.next());
            }
        }

        if(sealData == null || sealData.isEmpty())
            return null;
        
       return sealData;
    }

    /**
     * Parse the Code xml. The codes parsed are: Visibility, Pup and Loss. Given file must point to correctly XML file.
     * @param file - file to be parsed.
     * @param isAppFile - if true, file location is internal memory. If false, file location is external memory (SD)
     * @return ArrayList of all parsed codes
     */
    public HashMap parseCodeXml(String file, boolean isAppFile){
        HashMap sealData = parseXml(file, isAppFile, new SealCodeHandler());

        if(sealData == null || sealData.isEmpty())
            return null;

       return sealData;
    }

    /**
     * Parse the TagType xml. Given file must point to correctly XML file.
     * @param file - file to be parsed.
     * @param isAppFile - if true, file location is internal memory. If false, file location is external memory (SD)
     * @return ArrayList of all parsed tag types
     */
    public ArrayList parseTagTypeXml(String file, boolean isAppFile){

       ArrayList sealData = new ArrayList();

        HashMap map = parseXml(file, isAppFile, new SealTagTypeHandler());

        if(map != null){
            for(Iterator itr = map.values().iterator(); itr.hasNext(); ){
                sealData.add(itr.next());
            }
        }

        if(sealData == null || sealData.isEmpty())
            return null;

       return sealData;
    }

    /**
     * Parse the XML with the given handler. Given file must point to correctly XML file. It is recommended to use one of the
     * convenience methods to select the correct SealXmlHandler.
     * @param file - file to be parsed.
     * @param isAppFile - if true, file location is internal memory. If false, file location is external memory (SD)
     * @param handler - Handler for parsing xml. 
     * @return ArrayList of all parsed islands
     */
    public HashMap parseXml(String file, boolean isAppFile, SealXmlHandler handler){
         HashMap map = null;

         TOAST_DEBUG("Parse");
        if(isAppFile){
            LOG("SEAL APP FILE");
            map = parser.parseXml(handler,  file, context);
        }
        else{
            try{
                map = parser.parseXml(handler, new FileInputStream(file));
            }
            catch(Exception e){
                LOG("Parser Error: " + e + "");
                TOAST_DEBUG("Parser Error: " + e + "");
            }
        }
         

        return map;
    }
}
