/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.controllers.datacontrollers;

import org.me.sealproject.controllers.datacontrollers.xmlhandler.SealXmlHandler;

import android.content.Context;
import android.util.Log;

import java.io.*;
import java.util.HashMap;

import javax.xml.parsers.*;

/**
 *
 * @author samuelgbeecher
 */
public class SealXmlParser implements SealParser{
    public static final String DEBUG = "XML DEBUG";

    private HashMap map;

    public HashMap parseXml(SealXmlHandler handler, InputStream stream){
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            Log.d(DEBUG, "Parsing");
            saxParser.parse((stream), handler);
            
            map = handler.getHashMap();

            return map;
        } catch (FileNotFoundException f){
            Log.d(DEBUG, f + "");
            //throw new RuntimeException(f);
            return null;
        }
        catch (Exception e) {
            Log.d(DEBUG, e + "");
            //throw new RuntimeException(e);
            return null;
        }
    }

    public HashMap parseXml(SealXmlHandler handler, String appFilename, Context context) {
        try {
            return parseXml(handler, context.openFileInput(appFilename));

        } catch (FileNotFoundException f){
            Log.d(DEBUG, f + "");
            //throw new RuntimeException(f);
            return null;
        }
        catch (Exception e) {
            Log.d(DEBUG, e + "");
            //throw new RuntimeException(e);
            return null;
        }
    }

    public boolean writeXml(String xml, String filename, Context context){

        try {
            OutputStream out = context.openFileOutput(filename, Context.MODE_PRIVATE);
            out.write(xml.getBytes());
            out.close();

        } catch (Exception e) {
            return false;
        }
        return true;
    }

}
