/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.controllers.datacontrollers.xmlhandler;

import java.util.ArrayList;

import org.me.sealproject.sealdatatypes.SealCode;
import org.xml.sax.Attributes;

/**
 *
 * @author samuelgbeecher
 */
public class SealCodeHandler extends SealXmlHandler {

    public static final String CODE_ELEMENT = "Code";
    public static final String CODE_ATTRIBUTE_NAME = "name";

    public static final String ITEM_ELEMENT = "Item";
    public static final String ITEM_ATTRIBUTE_VALUE = "value";
    public static final String ITEM_ATTRIBUTE_DESCRIPTION = "description";


    @Override
    public void startElement(String elementName, Attributes attributes) {
        if(elementName.equalsIgnoreCase(CODE_ELEMENT)){
            String codeName = attributes.getValue(CODE_ATTRIBUTE_NAME);

            putIntoMap(codeName, new ArrayList());

            pushOntoStack(codeName);
        }
        else if(elementName.equalsIgnoreCase(ITEM_ELEMENT)){
            String key = (String)topOfStack();
            pushOntoStack(elementName);

            ArrayList values = (ArrayList)getFromMap(key);

            SealCode item = getSealCode(attributes);

            values.add(item);
        }
    }

    @Override
    public void endElement(String elementName) {
        popFromStack();
    }

    public SealCode getSealCode(Attributes attributes){
        String codeValue = attributes.getValue(ITEM_ATTRIBUTE_VALUE);

        SealCode code = new SealCode(codeValue);

        String codeDescription = attributes.getValue(ITEM_ATTRIBUTE_DESCRIPTION);

        code.setDescription(codeDescription);

        return code;
    }

}
