/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.controllers.datacontrollers.xmlhandler;

import org.me.sealproject.sealdatatypes.SealIsland;
import org.xml.sax.Attributes;

/**
 *
 * @author samuelgbeecher
 */
public class SealIslandHandler extends SealXmlHandler {
    public static final String ISLAND_ELEMENT = "Island";
    public static final String ROOKERY_ELEMENT = "Rookery";
    public static final String SECTION_ELEMENT = "Section";

    public static final String GENERAL_ATTRIBUTE_NAME = "name";

    @Override
    public void startElement(String elementName, Attributes attributes) {
        if(elementName.equalsIgnoreCase(ISLAND_ELEMENT)){
            String islandName = attributes.getValue(GENERAL_ATTRIBUTE_NAME);

            SealIsland island = new SealIsland(islandName);

            putIntoMap(islandName, island);
            pushOntoStack(islandName);
        }
        else if(elementName.equalsIgnoreCase(ROOKERY_ELEMENT)){
            String islandName = (String)topOfStack();

            SealIsland island = (SealIsland)getFromMap(islandName);

            String rookeryName = attributes.getValue(GENERAL_ATTRIBUTE_NAME);

            island.addRookery(rookeryName);

            pushOntoStack(rookeryName);
        }
        else if(elementName.equalsIgnoreCase(SECTION_ELEMENT)){
            String rookeryName = (String)popFromStack();
            String islandName = (String)topOfStack();
            pushOntoStack(rookeryName);

            SealIsland island = (SealIsland)getFromMap(islandName);

            String sectionName = attributes.getValue(GENERAL_ATTRIBUTE_NAME);

            island.addSection(rookeryName, sectionName);

            pushOntoStack(sectionName);
        }
    }

    @Override
    public void endElement(String elementName) {
        popFromStack();
    }

}
