/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.controllers.datacontrollers.xmlhandler;

import org.me.sealproject.sealdatatypes.SealTagType;
import org.xml.sax.Attributes;

/**
 *
 * @author samuelgbeecher
 */
public class SealTagTypeHandler extends SealXmlHandler{
    public static final String TYPE_ELEMENT = "TagType";
    public static final String TYPE_ATTRIBUTE_DESCRIPTION = "description";

    public static final String COLOR_ELEMENT = "Color";

    public static final String GENERAL_ATTRIBUTE_NAME = "name";

    @Override
    public void startElement(String elementName, Attributes attributes) {
        if(elementName.equalsIgnoreCase(TYPE_ELEMENT)){
            String typeName = attributes.getValue(GENERAL_ATTRIBUTE_NAME);

            SealTagType tagType = new SealTagType(typeName);

            String typeDescription = attributes.getValue(TYPE_ATTRIBUTE_DESCRIPTION);
            tagType.setDescription(typeDescription);

            pushOntoStack(typeName);
            putIntoMap(typeName, tagType);
        }
        else if(elementName.equalsIgnoreCase(COLOR_ELEMENT)){
            String typeName = (String)topOfStack();

            SealTagType tagType = (SealTagType)getFromMap(typeName);

            String color = attributes.getValue(GENERAL_ATTRIBUTE_NAME);
            tagType.addColor(color);

            pushOntoStack(color);
        }
    }

    @Override
    public void endElement(String elementName) {
       popFromStack();
    }

}
