/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.controllers.datacontrollers.xmlhandler;

import android.util.Log;

import java.util.ArrayList;
import java.util.HashMap;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/**
 * 
 * @author samuelgbeecher
 */
public abstract class SealXmlHandler extends DefaultHandler{
    public static final String DEBUG = "XML DEBUG";
    public static boolean DEBUGGING = false;

    private ArrayList stack;
    private HashMap hashMap;

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();

        stack = new ArrayList();
        hashMap = new HashMap();
    }

    @Override
    public void startElement(String uri, String elementName, String name, Attributes attributes) throws SAXException {
        super.startElement(uri, elementName, name, attributes);

        LOG("Start Element " + elementName);

        startElement(elementName, attributes);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        super.endElement(uri, localName, name);

        LOG("End Element " + localName);

        endElement(localName);
    }

    abstract public void startElement(String elementName, Attributes attributes);
    abstract public void endElement(String elementName);

    public HashMap getHashMap(){
        return  hashMap;
    }

    protected void putIntoMap(Object key, Object value){
        hashMap.put(key, value);
    }

    protected Object getFromMap(Object key){
        return hashMap.get(key);
    }

    protected void pushOntoStack(Object object){
        if(stack.isEmpty())
            stack.add(object);
        else
            stack.add(0, object);
    }

    protected Object popFromStack(){
        if(stack.isEmpty())
            return null;
        
        return stack.remove(0);
    }

    protected Object topOfStack(){
        if(stack.isEmpty())
            return null;
        
        return stack.get(0);
    }

    protected void LOG(String message){
        if(DEBUGGING){
            Log.d(DEBUG, message);
        }
    }

}

