/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.customwidgets;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.CompoundButton;
import android.widget.RadioButton;
import android.widget.RadioGroup;

/**
 *
 * @author samuelgbeecher
 */
public class ButtonGroup extends RadioGroup{
    private RadioButton hack;

    public ButtonGroup(Context context){
        super(context);

        setup(context);
    }

    public ButtonGroup(Context context, AttributeSet attrs) {
        super(context, attrs);

        setup(context);
    }

    private void setup(Context cont){
        hack = new RadioButton(cont);
        hack.setVisibility(View.GONE);

        addView(hack);
        uncheckAll();
    }

    /**
     * Uncheck all buttons contained within the group
     */
    public void uncheckAll(){
       // getCheckedButton().setChecked(false);
       // This is essentially a hack. The button is not visible, but when checked it will "uncheck" the other buttoms which are visible.
       hack.setChecked(true);
    }

    /**
     * Get the currently checked button within the group.
     * @return Checked button as a CompoundButton, or null if no button is checked
     */
    public CompoundButton getCheckedButton(){
        for(int i = 0; i < getChildCount(); i++){
            View view = this.getChildAt(i);
            if(view instanceof CompoundButton && view != hack){
                if(((CompoundButton)view).isChecked()){
                    return (CompoundButton)view;
                }
            }
        }
        return null;
    }

    /**
     * Set the checked button based on its label. Checking is case sensitive.
     * @param label
     */
    public boolean setCheckedByLabel(String label){
        for(int i = 0; i < getChildCount(); i++){
            View view = this.getChildAt(i);
            if(view instanceof CompoundButton && view != hack){
                if(((CompoundButton)view).getText().toString().equals(label)){
                   ((CompoundButton)view).setChecked(true);
                   return true;
                }
            }
        }
        return false;
    }

}
