/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.customwidgets;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.DialogInterface.OnClickListener;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.*;

import java.util.Calendar;

import org.me.sealproject.R;

/**
 *
 * @author samuelgbeecher
 */
public class CustomDatePickerDialogAdapter {
    private DatePicker picker;
    private OnDatePickedListener target;
    private Activity targetActivity;
    
    private AlertDialog thisDialog;

    public CustomDatePickerDialogAdapter(Activity activity){
        targetActivity = activity;
        setup();
    }

    private void setup(){
        LayoutInflater inflater = targetActivity.getLayoutInflater();

        View layout = inflater.inflate(R.layout.datepicker_view, null);

        Calendar c = Calendar.getInstance();
        int year = c.get(Calendar.YEAR);
        int month = c.get(Calendar.MONTH);
        int day = c.get(Calendar.DAY_OF_MONTH);

        picker = (DatePicker)layout.findViewById(R.id.datepicker_datepicker);
        picker.updateDate(year, month, day);

        AlertDialog.Builder builder = new AlertDialog.Builder(targetActivity);
        builder.setView(inflater.inflate(R.layout.datepicker_view, null));
        builder.setNegativeButton("Cancel", new NegativeClickListener());
        builder.setPositiveButton("Select", new AffirmativeClickListener());

        thisDialog = builder.create();
    }

    private class AffirmativeClickListener implements OnClickListener{
        public void onClick(DialogInterface arg0, int arg1) {
            if(target != null){
                target.onDatePicked(picker, picker.getYear(), picker.getMonth(), picker.getDayOfMonth());
            }

            Log.d("Custom Date Picker", "Affirmative Clicked");

            thisDialog.dismiss();
        }
    };

    private class NegativeClickListener implements OnClickListener {

        public void onClick(DialogInterface arg0, int arg1) {
            thisDialog.dismiss();
        }
    };

    public AlertDialog getDialog(){
        return thisDialog;
    }


    public interface OnDatePickedListener {
        public void onDatePicked(DatePicker picker, int year, int month, int day);
    }

    public void setOnDatePickedListener(OnDatePickedListener listener){
        target = listener;
    }
}
