/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.customwidgets;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.View;
import android.widget.*;
import java.util.ArrayList;

import org.me.sealproject.R;

/**
 *
 * @author samuelgbeecher
 */
public class SealValidationTable extends TableLayout {
    private boolean rowGrid;
    private ArrayList<SealValidationRow> rows;

    public SealValidationTable(Context context, boolean rowGrid){
        super(context);

        this.rowGrid = rowGrid;
    }


    public SealValidationTable(Context context) {
        super(context);
        setup();
    }

    public SealValidationTable(Context context, AttributeSet attrs) {
        super(context, attrs);
        setup();
    }

    private void setup(){
        rows = new ArrayList<SealValidationRow>();
    }

    public void addRow(SealValidationRow row, String description){
        if(row == null){
            return;
        }

        if(description != null){
            TextView desc = new TextView(getContext());
            desc.setText(description);
            desc.setTypeface(Typeface.SERIF);
            desc.setTextAppearance(getContext(), R.style.validation_description_style);

            this.addView(desc);
        }
        
        rows.add(row);
        this.addView(row);

        if(rowGrid){
            this.addView(getGridLine());
        }
    }

    public void addRow(SealValidationRow row){
       addRow(row, row.getLabel());
    }

    public void setDrawGrid(boolean draw){
        rowGrid = draw;
    }

    public boolean isDrawingGrid(){
        return rowGrid;
    }

    private View getGridLine(){
        View v = new View(getContext());
        v.setLayoutParams(new LayoutParams(LayoutParams.FILL_PARENT,2));
        v.setBackgroundColor(Color.argb(255,255,255,255));
        return v;
    }

    public ArrayList<SealValidationRow> getRows(){
        return rows;
    }
}
