/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.customwidgets;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import java.util.ArrayList;

/**
 *
 * @author samuelgbeecher
 */
public class TextBox extends AutoCompleteTextView {
    private ArrayList<String> list;

    public TextBox(Context context) {
        super(context);
    }

    public TextBox(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public TextBox(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setAdapter(ArrayList<String> list) {
        this.list = list;
        ArrayAdapter<String> adapter = new ArrayAdapter(this.getContext(), android.R.layout.simple_dropdown_item_1line, list);
        setAdapter(adapter);
    }

    public String getString(){
        return this.getText().toString();
    }

    public void addItemToAdapter(String item){
        list.add(item);
        setAdapter(list);
    }

    public void removeItemFromAdapter(String item){
        list.remove(item);
        setAdapter(list);
    }



}
