/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.database;

import android.content.ContentValues;
import android.database.Cursor;
import org.me.sealproject.sealdatatypes.Seal;
import org.me.sealproject.sealdatatypes.SealObservation;
import org.me.sealproject.sealdatatypes.SealTag;

/**
 *
 * @author samuelgbeecher
 */
public class Observations extends SealBaseColumns {
    public static final String NAME = "Observation";

  /** PK int, AutoIncrement. First Column. */
    public static final String ID = "id";
    /** Integer unix representative time. Second Column. */
    public static final String DATETIME = "entryDateTime";
    /** String two char. Third column. */
    public static final String OBSERVER = "observer"; // String
    /** String. Fourth Column. */
    public static final String ISLAND = "island";
    /** String. Fifth Column. */
    public static final String ROOKERY = "rookery";
    /** int. Sixth Column. */
    public static final String ROOKERY_SECTION = "rookerySection"; // int
    /** int. Seventh Column. */
    public static final String SEAL_NUM = "sealNumber"; // int
    /** int. Eighth Column. */
    public static final String VISIBILITY = "visibilityCode"; // int

    /** String. Ninth Column. */
    public static final String FIRST_TAG = "firstTagId"; // fk String

    /** String. Tenth Column. */
    public static final String FIRST_TAG_SIDE = "firstTagSide";

    /** String. Eleventh Column. */
    public static final String FIRST_TAG_TYPE = "FirstTagType";

    /** int. Twelvth Column. */
    public static final String FIRST_TAG_LOSS = "firstTagLossCode"; // int

    public static final String FIRST_TAG_COLOR = "firstTagColor";

    /** boolean (int). Thirteenth Column. */
    public static final String FIRST_TAG_CONFIRMED = "firstTagConfirmed"; // boolean (int)

    /** boolean (int). Fourteenth Column. */
    public static final String SECOND_TAG_SEEN = "secondTagSeen"; // boolean (int)

    /** boolean (int). */
    public static final String SECOND_FLIPPER_SEEN = "secondFlipperSeen"; // boolean (int)

    /** String. Fifteenth Column. */
    public static final String SECOND_TAG = "secondTagId"; // fk String

    /** String. Sixteenth Column. */
    public static final String SECOND_TAG_SIDE = "secondTagSide";

    /** int. Seventeenth Column. */
    public static final String SECOND_TAG_LOSS = "secondTagLossCode"; // int

       /** String. Eighteenth Column. */
    public static final String SECOND_TAG_TYPE = "secondTagType";

    /** String. Nineteenth Column. */
    public static final String SECOND_TAG_COLOR = "secondTagColor";

    /** boolean (int). Twentieth Column. */
    public static final String SECOND_TAG_CONFIRMED = "secondTagConfirmed"; // boolean (int)

    /** String. Twenty First Column. */
    public static final String AGE = "ageCode"; // int

    /** String. Twenty Second Column. */
    public static final String SEX = "sex";

    /** int. Twenty Third Column.*/
    public static final String PUP_CODE = "pupCode"; // int

    /** boolean (int). Twenty Fourth Column.*/
    public static final String PHOTOS_TAKEN = "photosTaken"; // boolean (int)

    /** String. Twenty Fifth Column.*/
    public static final String COMMENTS = "comments"; // String

     public static final String CREATE_OBSERVATION_TABLE = "CREATE TABLE "+NAME+" ("
                                                    +ID+" INTEGER PRIMARY KEY AUTOINCREMENT, "
                                                    +DATETIME+" INTEGER NOT NULL, "
                                                    +OBSERVER+" TEXT NOT NULL, "
                                                    +ISLAND+" TEXT NOT NULL, "
                                                    +ROOKERY+" TEXT NOT NULL, "
                                                    +ROOKERY_SECTION+" TEXT NOT NULL, "
                                                    +SEAL_NUM+" INTEGER NOT NULL, "
                                                    +VISIBILITY+" INTEGER NOT NULL, "
                                                    +FIRST_TAG+" TEXT, "
                                                    +FIRST_TAG_SIDE+" TEXT, "
                                                    +FIRST_TAG_TYPE+" TEXT, "
                                                    +FIRST_TAG_LOSS+" INTEGER, "
                                                    +FIRST_TAG_COLOR+" TEXT, "
                                                    +FIRST_TAG_CONFIRMED+" INTEGER, "
                                                    +SECOND_TAG_SEEN+" INTEGER, "
                                                    +SECOND_FLIPPER_SEEN+" INTEGER, "
                                                    +SECOND_TAG+" TEXT, "
                                                    +SECOND_TAG_SIDE+" TEXT, "
                                                    +SECOND_TAG_TYPE+" TEXT, "
                                                    +SECOND_TAG_LOSS+" INTEGER, "
                                                    +SECOND_TAG_COLOR+" TEXT, "
                                                    +SECOND_TAG_CONFIRMED+" INTEGER, "
                                                    +AGE+" TEXT, "
                                                    +SEX+" TEXT, "
                                                    +PUP_CODE+" INTEGER, "
                                                    +PHOTOS_TAKEN+" INTEGER, "
                                                    +COMMENTS+" TEXT);";

     /*
      * public static final String TRIGGER_ADD = "fk_insert_observation";
         public static final String TRIGGER_UPDATE = "fk_update_observation";

         public static final String CREATE_TRIGGER_ADD = "CREATE TRIGGER "+TRIGGER_ADD+" BEFORE INSERT ON "+OBSERVATION_TABLE+" FOR EACH ROW BEGIN  "
                 + "SELECT RAISE(ROLLBACK, 'insert on table \""+OBSERVATION_TABLE+"\" violates foreign key constraint \""+ObservationColumns.FIRST_TAG+"\"') WHERE  "
                 + "(SELECT "+TagColumns.ID+" FROM "+TAG_TABLE+" WHERE NEW."+ObservationColumns.FIRST_TAG+" IS NOT NULL AND "+TagColumns.ID+" = NEW."+ObservationColumns.FIRST_TAG+") IS NULL; "
                 + "SELECT RAISE(ROLLBACK, 'insert on table \""+OBSERVATION_TABLE+"\" violates foreign key constraint \""+ObservationColumns.SECOND_TAG+"\"') WHERE  "
                 + "(SELECT "+TagColumns.ID+" FROM "+TAG_TABLE+" WHERE NEW."+ObservationColumns.SECOND_TAG+" IS NOT NULL AND "+TagColumns.ID+" = NEW."+ObservationColumns.SECOND_TAG+") IS NULL; "
                 + "END;";

         public static final String CREATE_TRIGGER_UPDATE = "CREATE TRIGGER "+TRIGGER_UPDATE+" BEFORE INSERT ON "+OBSERVATION_TABLE+" FOR EACH ROW BEGIN  "
                 + "SELECT RAISE(ROLLBACK, 'update on table \""+OBSERVATION_TABLE+"\" violates foreign key constraint \""+ObservationColumns.FIRST_TAG+"\"') WHERE  "
                 + "(SELECT "+TagColumns.ID+" FROM "+TAG_TABLE+" WHERE NEW."+ObservationColumns.FIRST_TAG+" IS NOT NULL AND "+TagColumns.ID+" = NEW."+ObservationColumns.FIRST_TAG+") IS NULL; "
                 + "SELECT RAISE(ROLLBACK, 'update on table \""+OBSERVATION_TABLE+"\" violates foreign key constraint \""+ObservationColumns.SECOND_TAG+"\"') WHERE  "
                 + "(SELECT "+TagColumns.ID+" FROM "+TAG_TABLE+" WHERE NEW."+ObservationColumns.SECOND_TAG+" IS NOT NULL AND "+TagColumns.ID+" = NEW."+ObservationColumns.SECOND_TAG+") IS NULL; "
                 + "END;";
      */

      public static ContentValues getValuesFromData(SealObservation obs){
        ContentValues values = new ContentValues();

        values.put(DATETIME, obs.getDatetime());
        values.put(OBSERVER, obs.getObserver());
        values.put(ISLAND, obs.getIsland());
        values.put(ROOKERY, obs.getRookery());
        values.put(ROOKERY_SECTION, obs.getRookerySection());
        values.put(VISIBILITY, obs.getVisibilityCode());

        values.put(SEAL_NUM, obs.getSealNum());

        Seal seal = obs.getSeal();
        SealTag firstTag = seal.getFirstTag();
        SealTag secondTag = seal.getSecondTag();

        if(firstTag.getNumber() != null)
            values.put(FIRST_TAG, firstTag.getNumber());

        values.put(FIRST_TAG_SIDE, firstTag.getSide());

        if(firstTag.getType() != null)
            values.put(FIRST_TAG_TYPE, firstTag.getType());


        values.put(FIRST_TAG_LOSS, firstTag.getLossCode());

        values.put(FIRST_TAG_COLOR, firstTag.getColor());
        values.put(FIRST_TAG_CONFIRMED, obs.isFirstTagConfirmed());

        values.put(SECOND_TAG_SEEN, obs.isOtherFlipperSeen());
        values.put(SECOND_FLIPPER_SEEN, obs.isOtherTagSeen());

        if(obs.isOtherFlipperSeen() || obs.isOtherTagSeen()){
            if(secondTag.getNumber() != null)
                values.put(SECOND_TAG, secondTag.getNumber());

            values.put(SECOND_TAG_SIDE, secondTag.getSide());

            if(secondTag.getType() != null)
                values.put(SECOND_TAG_TYPE, secondTag.getType());

            values.put(SECOND_TAG_LOSS, secondTag.getLossCode());

            values.put(SECOND_TAG_COLOR, secondTag.getColor());
            values.put(SECOND_TAG_CONFIRMED, obs.isSecondTagConfirmed());
        }

        values.put(AGE, obs.getAge());
        values.put(SEX, seal.getSex());

        if(obs.getPupCode() >= 0){
            values.put(PUP_CODE, obs.getPupCode());
        }

        values.put(PHOTOS_TAKEN, obs.isPhotosTaken());
        values.put(COMMENTS, obs.getComments());

        return values;
    }

    public static SealObservation getDataFromCursor(Cursor c){
        SealObservation obs = new SealObservation();

        obs.setId(c.getInt(c.getColumnIndex(ID)));
        obs.setDatetime(c.getLong(c.getColumnIndex(DATETIME)));
        obs.setObserver(c.getString(c.getColumnIndex(OBSERVER)));
        obs.setIsland((c.getString(c.getColumnIndex(ISLAND))));
        obs.setRookery(c.getString(c.getColumnIndex(ROOKERY)));
        obs.setRookerySection(c.getString(c.getColumnIndex(ROOKERY_SECTION)));
        obs.setVisibilityCode(c.getInt(c.getColumnIndex(VISIBILITY)));
        obs.setSealNum(c.getInt(c.getColumnIndex(SEAL_NUM)));

        Seal seal = new Seal();
        SealTag firstTag = new SealTag();
        SealTag secondTag = new SealTag();

        firstTag.setNumber(c.getString(c.getColumnIndex(FIRST_TAG)));
        firstTag.setType(c.getString(c.getColumnIndex(FIRST_TAG_TYPE)));

        firstTag.setLossCode((c.getInt(c.getColumnIndex(FIRST_TAG_LOSS))));
        
        firstTag.setColor(c.getString(c.getColumnIndex(FIRST_TAG_COLOR)));
        firstTag.setSide(c.getString(c.getColumnIndex(FIRST_TAG_SIDE)));

        seal.setFirstTag(firstTag);

        obs.setOtherFlipperSeen(c.getInt(c.getColumnIndex(SECOND_TAG_SEEN)) == 1);
        obs.setOtherFlipperSeen(c.getInt(c.getColumnIndex(SECOND_FLIPPER_SEEN)) == 1);

        if(obs.isOtherFlipperSeen() || obs.isOtherTagSeen()){
            secondTag.setNumber(c.getString(c.getColumnIndex(SECOND_TAG)));
            secondTag.setType(c.getString(c.getColumnIndex(SECOND_TAG_TYPE)));
            secondTag.setLossCode((c.getInt(c.getColumnIndex(SECOND_TAG_LOSS))));
            
            secondTag.setColor(c.getString(c.getColumnIndex(SECOND_TAG_COLOR)));
            secondTag.setSide(c.getString(c.getColumnIndex(SECOND_TAG_SIDE)));
        }
        else{
            secondTag = null;
        }

        seal.setSecondTag(secondTag);

        seal.setSex(c.getString(c.getColumnIndex(SEX)));
        seal.setLastSeen(c.getLong(c.getColumnIndex(DATETIME)));

        obs.setSeal(seal);

        obs.setFirstTagConfirmed(c.getInt(c.getColumnIndex(FIRST_TAG_CONFIRMED)) == 1);
        obs.setSecondTagConfirmed(c.getInt(c.getColumnIndex(SECOND_TAG_CONFIRMED)) == 1);

        obs.setAge(c.getString(c.getColumnIndex(AGE)));
        obs.setPupCode(c.getInt(c.getColumnIndex(PUP_CODE)));
        obs.setPhotosTaken(c.getInt(c.getColumnIndex(PHOTOS_TAKEN)) == 1);
        obs.setComments(c.getString(c.getColumnIndex(COMMENTS)));

        return obs;
    }
}
