/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.database;

import android.content.ContentValues;
import android.database.Cursor;
import org.me.sealproject.sealdatatypes.Seal;

/**
 *
 * @author samuelgbeecher
 */
public class Seals extends SealBaseColumns{
    public static final String NAME = "Seal";

    public static final String ID = "sealId"; // pk string
    /** String. Second Column. */
    public static final String SEX = "sex"; // character
    /** date (int). Fourth Column. */
    public static final String LAST_SEEN = "lastSeen";

    public static final String CREATE_SEAL_TABLE = "CREATE TABLE "+NAME+" ("
                                                    +ID+" TEXT PRIMARY KEY, "
                                                    +SEX+" TEXT, "
                                                    +LAST_SEEN+" INTEGER);";

    
     // Constraints
     public static final String TRIGGER_DELETE = "fk_delete_seal";
     public static final String TRIGGER_UPDATE = "fk_update_seal";

      /** Restrict Delete */
      public static final String CREATE_TRIGGER_DELETE = "CREATE TRIGGER "+TRIGGER_DELETE+" BEFORE DELETE ON "+NAME+" FOR EACH ROW BEGIN  "
             + "SELECT RAISE(ROLLBACK, 'delete on table \""+NAME+"\" violates foreign key constraint \""+Tags.SEAL_ID+"\"') WHERE  "
             + "(SELECT "+Tags.SEAL_ID+" FROM "+Tags.NAME+" WHERE "+Tags.SEAL_ID+" = OLD."+ID+") IS NOT NULL; "
             + "END;";

      /** Cascade Update */
      public static final String CREATE_TRIGGER_UPDATE = "CREATE TRIGGER "+TRIGGER_UPDATE+" AFTER UPDATE ON "+NAME+" FOR EACH ROW BEGIN  "
             + "UPDATE "+Tags.NAME+" SET "+Tags.SEAL_ID+" = NEW."+ID+" WHERE "+Tags.SEAL_ID+" = OLD."+ID+";"
             + "END;";

      
      public static ContentValues getValuesFromData(Seal seal){
        ContentValues values = new ContentValues();
        if(seal.getId() == null)
            return null;

        values.put(Seals.ID, seal.getId());
        values.put(Seals.SEX, seal.getSex());
        values.put(Seals.LAST_SEEN, seal.getLastSeen());

        return values;
      }

      public static Seal getDataFromCursor(Cursor c){
        Seal seal = new Seal();

        seal.setId(c.getString(c.getColumnIndex(Seals.ID)));
        seal.setSex(((c.getString(c.getColumnIndex(Seals.SEX)))));
        seal.setLastSeen(c.getInt(c.getColumnIndex(Seals.LAST_SEEN)));

        return seal;
      }
}
