/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.sealdatatypes;

import java.io.Serializable;

/**
 *
 * @author samuelgbeecher
 */
public class SealTag extends SealDataType implements Serializable{
    private static final long serialVersionUID = 2;

    private String number;
    private String sealId;
    private String type;
    private String color;
    private String side;
    private int lossCode;

    public SealTag(){
            number = null;
            sealId = null;
            type = null;
            color = null;
            side = null;
            lossCode = -1;
    }

    public void setLossCode(int lost) {
            lossCode = lost;
    }


    public int getLossCode() {
            return lossCode;
    }

    public void setSide(String side) {
            this.side = side;
    }


    public String getSide() {
            return side;
    }


    public void setColor(String color) {
            this.color = color;
    }


    public String getColor() {
            return color;
    }


    public void setType(String tagType) {
            this.type = tagType;
    }


    public String getType() {
            return type;
    }


    public void setSealId(String sealId) {
            this.sealId = sealId;
    }


    public String getSealId() {
            return sealId;
    }

    public void setNumber(String tagNumber) {
            this.number = tagNumber;
    }


    public String getNumber() {
            return number;
    }

    public boolean isLost(){
        return lossCode >= 0;
    }

    public SealTag copy() {
            SealTag copy = new SealTag();

            copy.setLossCode(this.getLossCode());
            copy.setSide(this.getSide());
            copy.setColor(this.getColor());
            copy.setType(this.getType());
            copy.setSealId(this.getSealId());
            copy.setNumber(this.getNumber());

            return copy;
    }

    public boolean equals(Object obj){
        if(obj == null){
            return false;
        }
        else if (obj == this){
            return true;
        }
        else if(obj instanceof SealTag){
            SealTag tag = (SealTag)obj;

            boolean returnVal = tag.getNumber().equals(this.getNumber()) &&
                    tag.getLossCode() == this.getLossCode() &&
                    ((tag.getType() != null && tag.getType().equalsIgnoreCase(this.getType())) || tag.getType() == this.getType()) &&
                    ((tag.getColor() != null && tag.getColor().equalsIgnoreCase(this.getColor())) || tag.getColor() == this.getColor()) &&
                    tag.getSide().equalsIgnoreCase(this.getSide());

            return returnVal;
        }
        else{
            return false;
        }
    }

    public String toString(){
        String info = "";

        info += "\nSide: " + side;
        info += "\nType: " + type;
        info += "\nColor: " + color;
        info += "\nNumber: " + number;
        info += "\nLoss: " + lossCode;

        return info;
    }

}

