/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package sealsync;

import java.awt.List;
import java.awt.event.*;
import java.io.File;
import java.util.Observable;
import java.util.Observer;
import javax.swing.*;

/**
 *
 * @author samuelgbeecher
 */
public class ChooserPane extends JFrame implements WindowListener, ActionListener, Runnable {
    public static final int WIDTH = 250;
    public static final int HEIGHT = 400;

    public static final String title = "USB Chooser";

    private MyObservable myObservable;
    private List myList;
    private boolean selectionMade;
    private boolean stillRunning;

    public ChooserPane(File[] usbs, Observer obs){
        setSize(WIDTH, HEIGHT);
        addWindowListener(this);
        setTitle(title);

        JPanel myPanel = new JPanel();
        myPanel.setLayout(new BoxLayout(myPanel, BoxLayout.Y_AXIS));
        add(myPanel);

        myList = new List();

        for(int i = 0; i < usbs.length; i++){
            myList.add(usbs[i].getName());
        }
        myPanel.add(myList);

        JButton select = new JButton("Select");
        select.addActionListener(this);
        myPanel.add(select);

        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent ae) {
                close();
            }
        });
        myPanel.add(cancel);

        myObservable = new MyObservable();
        myObservable.addObserver(obs);
    }

    public void close(){
        if(!selectionMade)
            myObservable.notifyObservers(new Integer(-1));

        stillRunning = false;
        this.dispose();
    }

    public void windowOpened(WindowEvent we) {}

    public void windowClosing(WindowEvent we) {
        close();
    }

    public void windowClosed(WindowEvent we) {}

    public void windowIconified(WindowEvent we) {}

    public void windowDeiconified(WindowEvent we) {}

    public void windowActivated(WindowEvent we) {}

    public void windowDeactivated(WindowEvent we) {}

    public void actionPerformed(ActionEvent ae) {
        if(myList.getSelectedIndex() >= 0){
            selectionMade = true;
            myObservable.notifyObservers(new Integer(myList.getSelectedIndex()));
            close();
        }
    }

    public void run() {
        setVisible(true);

    }

    class MyObservable extends Observable{
        public void notifyObservers(Object o){
            super.setChanged();
            super.notifyObservers(o);
        }
    }
}


