/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package sealsync.ExcelParser;

import java.io.File;
import org.apache.poi.xssf.usermodel.*;

/**
 *
 * @author samuelgbeecher
 */
public class CodeExcelParser extends ExcelParser {
    public static final boolean DEBUG = false;

    public static final String CODE_SHEET_NAME = "Codes";

    public static final int CODE_NAME_COLUMN = 0;
    public static final int CODE_VALUE_COLUMN = 1;
    public static final int CODE_DESCRIPTION_COLUMN = 2;

    public static final String CODE_ELEMENT = "Code";
    public static final String CODE_ATTRIBUTE_NAME = "name";

    public static final String ITEM_ELEMENT = "Item";
    public static final String ITEM_ATTRIBUTE_VALUE = "value";
    public static final String ITEM_ATTRIBUTE_DESCRIPTION = "description";

    private XSSFSheet codes;

    public CodeExcelParser(File workbookDir){
        super(workbookDir);
        codes = workbook.getSheet(CODE_SHEET_NAME);
    }

    public XmlElement parseExcelForCodes(){
        XmlElement sealCodes = new XmlElement("Codes");


        XSSFRow row;
        XSSFCell cell;

        XmlElement code = null;
        String currentCodeName = null, nextCodeName;

        int inc = 0;
        while(true){
            inc++;

            row = codes.getRow(inc);
            if(row == null){
                if(DEBUG)
                    System.out.println("Found Empty Row. Done Parsing");

                break;
            }

            cell = row.getCell(CODE_NAME_COLUMN);
            if(!cellIsValid(cell)){
                if(DEBUG)
                    System.out.println("Found Empty Cell At Code Name Column. Done Parsing");

                break;
            }

            nextCodeName = cell.getStringCellValue();

            if(!nextCodeName.equalsIgnoreCase(currentCodeName)){
                currentCodeName = nextCodeName;

                code = new XmlElement(CODE_ELEMENT);
                code.putAttributeWithValue(CODE_ATTRIBUTE_NAME, currentCodeName);
                sealCodes.addChild(code);
            }

            XmlElement item = getItem(row);

            code.addChild(item);
        }

        return sealCodes;
    }

    private boolean cellIsValid(XSSFCell cell){
        boolean valid = cell != null && cell.getCellType() != XSSFCell.CELL_TYPE_BLANK;
        return valid;
    }

    private String getCodeValueAsString(XSSFCell cell){
        String value;
        try{
            value = cell.getStringCellValue();
        }
        catch(Exception e){
            value = (int)cell.getNumericCellValue()+ "";
        }

        return value;
    }

    private XmlElement getItem(XSSFRow row){
        XSSFCell cell = row.getCell(CODE_VALUE_COLUMN);
        XmlElement item = new XmlElement(ITEM_ELEMENT);

        String codeValue = getCodeValueAsString(cell);

        item.putAttributeWithValue(ITEM_ATTRIBUTE_VALUE, codeValue);

        cell = row.getCell(CODE_DESCRIPTION_COLUMN);

        String codeDescription = cell.getStringCellValue();

        item.putAttributeWithValue(ITEM_ATTRIBUTE_DESCRIPTION, codeDescription);

        return item;

    }

}
