/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package sealsync.ExcelParser;

import java.io.File;
import org.apache.poi.xssf.usermodel.*;

/**
 *
 * @author samuelgbeecher
 */
public class IslandExcelParser extends ExcelParser {
      public static boolean DEBUG = true;

      public static final String ROOKERY_SHEET_NAME = "Rookeries";

      public static final int ISLAND_COLUMN = 0;
      public static final int ROOKERY_COLUMN = 1;
      public static final int SECTION_START_COLUMN = 2;

      public static final String ISLAND_ELEMENT = "Island";
      public static final String ROOKERY_ELEMENT = "Rookery";
      public static final String SECTION_ELEMENT = "Section";

      public static final String GENERAL_ATTRIBUTE_NAME = "name";

      private XSSFSheet rookeries;

      public IslandExcelParser(File dir){
          super(dir);
          rookeries = workbook.getSheet(ROOKERY_SHEET_NAME);
      }

      public XmlElement parseExcelForRookeries(){
            XmlElement islands = new XmlElement("SealIslands");
            XmlElement islandElement = null;

            String currentIslandName = null, nextIslandName;
            XSSFRow row;
            XSSFCell cell;
            int inc = 0;

            while(true){

                inc++;

                row = rookeries.getRow(inc);
                if(row == null){
                    if(DEBUG)
                        System.out.println("Found Empty Row. Done Parsing");
                    break;
                }

                cell = row.getCell(ISLAND_COLUMN);

                if(!cellIsValid(cell)){
                    if(DEBUG)
                        System.out.println("Found Empty Cell At Island Column. Done Parsing");
                    break;
                }

                nextIslandName = cell.getStringCellValue();

                if(!nextIslandName.equalsIgnoreCase(currentIslandName)){
                    currentIslandName = nextIslandName;
                    
                    islandElement = new XmlElement(ISLAND_ELEMENT);
                    islandElement.putAttributeWithValue(GENERAL_ATTRIBUTE_NAME, currentIslandName);
                    
                    islands.addChild(islandElement);
                }

                XmlElement rookeryElement = getRookery(row);

                // Islands could realistically have No rookeries. Hence, this is an option
                if(rookeryElement != null){
                    // Island has no rookeries. Just continue.
                     islandElement.addChild(rookeryElement);
                }
            }

            return islands;
      
      }

      private boolean cellIsValid(XSSFCell cell){
          boolean valid = cell != null && cell.getCellType() != XSSFCell.CELL_TYPE_BLANK;
          return valid;
      }

      private XmlElement getRookery(XSSFRow row){
            XSSFCell cell = row.getCell(ROOKERY_COLUMN);

            if(!cellIsValid(cell)){
                if(DEBUG)
                    System.out.println("Found Empty Cell At Rookery Column. Done Parsing");
                return null;
            }

            String rookeryName = cell.getStringCellValue();

            XmlElement rookeryElement = new XmlElement(ROOKERY_ELEMENT);
            rookeryElement.putAttributeWithValue(GENERAL_ATTRIBUTE_NAME, rookeryName);

            int inc = SECTION_START_COLUMN - 1;
            while(true){
                inc++;
                
                cell = row.getCell(inc);

                if(!cellIsValid(cell)){
                    break;
                }
                
                String sectionName;
                try{
                   sectionName = cell.getStringCellValue();
                }
                catch(Exception e){
                    sectionName = (int)cell.getNumericCellValue() + "";
                }

                XmlElement sectionElement = new XmlElement(SECTION_ELEMENT);
                sectionElement.putAttributeWithValue(GENERAL_ATTRIBUTE_NAME, sectionName);

                rookeryElement.addChild(sectionElement);
            }

            return rookeryElement;
      }
}
