/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package sealsync.ExcelParser;


import java.io.File;
import java.text.DecimalFormat;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.xssf.usermodel.*;

/**
 * Reads IDLook up Sheet and Code Sheet to get usable information
 * @author samuelgbeecher
 */
public class SealExcelParser extends ExcelParser {
    public static boolean DEBUG = false;

    public static final String RIGHT = "right";
    public static final String LEFT = "left";

    public static int SEAL_ID_COLUMN = 0;
    public static int TAG_SIDE_COLUMN = 2;
    public static int SEAL_SEX_COLUMN = 3;
    public static int SECOND_TAG_EXISTS_COLUMN = 4;
    public static int SEAL_LAST_SEEN_COLUMN = 5;

    public static int FIRST_TAG_TYPE_COLUMN = 6;
    public static int FIRST_TAG_NUMBER_COLUMN = 7;
    public static int FIRST_TAG_COLOR_COLUMN = 8;
    
    public static int SECOND_TAG_TYPE_COLUMN = 9;
    public static int SECOND_TAG_NUMBER_COLUMN = 10;
    public static int SECOND_TAG_COLOR_COLUMN = 11;

    public static final String SEAL_ID_SHEET_NAME = "IDLookup";

    public static String SEAL_ATTRIBUTE_ID = "id";
    public static String SEAL_ATTRIBUTE_SEX = "sex";
    public static String SEAL_ATTRIBUTE_LASTSEEN = "lastSeen";
    
    public static String TAG_ATTRIBUTE_ID = "number";
    public static String TAG_ATTRIBUTE_SIDE = "side";
    public static String TAG_ATTRIBUTE_COLOR = "color";
    public static String TAG_ATTRIBUTE_TYPE = "type";

    public enum IdColumns{
        ID,
        TagNum,
        TagSide
    };

    public static final char TAG_SIDE_BOTH = 'B';
    public static final char TAG_SIDE_LEFT = 'L';
    public static final char TAG_SIDE_RIGHT = 'R';

    private XmlElement seals;
    private XSSFSheet idLookup;

    public SealExcelParser(File f){
        super(f);

        seals = null;

        idLookup = workbook.getSheet(SEAL_ID_SHEET_NAME);
        
    }

    public XmlElement parseExcelForSeals(){
        if(seals != null){
            return seals;
        }

        if(DEBUG)
            System.out.println("Start Parsing");

        seals = new XmlElement("DatabaseSeals");

        XSSFRow row;
        XSSFCell cell;
        XmlElement seal;
        String previousId = "";
        String sealInfo;

        int inc = 0;

        while(true){
            inc++;

            if(DEBUG)
                System.out.println("Geting Seal # " + inc);

            seal = new XmlElement("Seal");

            if((row = idLookup.getRow(inc)) == null){
                break;
            }

            cell = row.getCell(SEAL_ID_COLUMN);

            if(cell == null || cell.getCellType() == XSSFCell.CELL_TYPE_BLANK || cell.getStringCellValue().equals("")){
                break;
            }

            // get seal Id column and check if it matches previous one
            sealInfo = cell.getStringCellValue();
            if(previousId.equalsIgnoreCase(sealInfo)){
                continue;
            }
            
            seal.putAttributeWithValue(SEAL_ATTRIBUTE_ID, sealInfo);

            sealInfo = row.getCell(SEAL_SEX_COLUMN).getStringCellValue();

            seal.putAttributeWithValue(SEAL_ATTRIBUTE_SEX, sealInfo);

            try{
               // sealInfo = row.getCell(SEAL_LAST_SEEN_COLUMN);
                Calendar calendar = Calendar.getInstance();
                int year = (int)row.getCell(SEAL_LAST_SEEN_COLUMN).getNumericCellValue();
                calendar.set(year, 1, 1);
                seal.putAttributeWithValue(SEAL_ATTRIBUTE_LASTSEEN, calendar.getTime().getTime()/1000 + "");
            }
            catch(NumberFormatException nfException){
                System.out.println(nfException.getMessage());
            }

            if(DEBUG)
                System.out.println("Getting Seal Tags");

            ArrayList<XmlElement> tags = this.getTagsFromRow(row);

            for(XmlElement tag : tags){
                seal.addChild(tag);
            }

            seals.addChild(seal);
        }

        if(DEBUG)
            System.out.println("Finished Parsing");

        return seals;
    }

    public ArrayList<XmlElement> getTagsFromRow(XSSFRow row){
        ArrayList<XmlElement> tags = new ArrayList<XmlElement>(2);
        XmlElement tag = new XmlElement("Tag");
        String tagInfo;
        String otherSide;
        
        if(DEBUG)
            System.out.println("Getting First Tag");

        tagInfo = row.getCell(FIRST_TAG_TYPE_COLUMN).getStringCellValue();
        tag.putAttributeWithValue(TAG_ATTRIBUTE_TYPE, tagInfo);

        XSSFCell cell = row.getCell(FIRST_TAG_NUMBER_COLUMN);
        
        if(cell.getCellType() == XSSFCell.CELL_TYPE_NUMERIC){
            tagInfo = removeTrailingZeros(cell.getNumericCellValue() + "", true);
        }
        else{

            tagInfo = cell.getStringCellValue();
        }
        
        tag.putAttributeWithValue(TAG_ATTRIBUTE_ID, tagInfo);

        cell = row.getCell(FIRST_TAG_COLOR_COLUMN);
        
        if(cell != null && cell.getCellType() != XSSFCell.CELL_TYPE_BLANK){
            tagInfo = cell.getStringCellValue();
            tag.putAttributeWithValue(TAG_ATTRIBUTE_COLOR, tagInfo);
        }

        tagInfo = row.getCell(TAG_SIDE_COLUMN).getStringCellValue();

        if(tagInfo.toUpperCase().charAt(0) == TAG_SIDE_BOTH){
            tag.putAttributeWithValue(TAG_ATTRIBUTE_SIDE, LEFT);
            tags.add(tag);
            
            tag = tag.clone();


            tag.putAttributeWithValue(TAG_ATTRIBUTE_SIDE, RIGHT);
            tags.add(tag);
        }
        else{
            tag.putAttributeWithValue(TAG_ATTRIBUTE_SIDE, (tagInfo.equalsIgnoreCase("R") ? RIGHT : LEFT));
            tags.add(tag);

            if(tagInfo.toUpperCase().charAt(0) == TAG_SIDE_RIGHT){
                otherSide = LEFT;
            }
            else{
                otherSide = RIGHT;
            }

            tagInfo = row.getCell(SECOND_TAG_EXISTS_COLUMN).getStringCellValue();

            if(tagInfo != null && !tagInfo.equalsIgnoreCase("none") && !tagInfo.equals("")){
                tag = new XmlElement("Tag");

                tag.putAttributeWithValue(TAG_ATTRIBUTE_SIDE, otherSide);

                tagInfo = row.getCell(SECOND_TAG_TYPE_COLUMN).getStringCellValue();
                tag.putAttributeWithValue(TAG_ATTRIBUTE_TYPE, tagInfo);

                cell = row.getCell(SECOND_TAG_NUMBER_COLUMN);
                if(cell.getCellType() == XSSFCell.CELL_TYPE_NUMERIC){
                    tagInfo = removeTrailingZeros(cell.getNumericCellValue() + "", true);
                }
                else{
                    tagInfo = cell.getStringCellValue();
                }

                tag.putAttributeWithValue(TAG_ATTRIBUTE_ID, tagInfo);

                cell = row.getCell(SECOND_TAG_COLOR_COLUMN);
                if(cell != null && cell.getCellType() != XSSFCell.CELL_TYPE_BLANK){
                    tagInfo = cell.getStringCellValue();
                    tag.putAttributeWithValue(TAG_ATTRIBUTE_COLOR, tagInfo);
                }

                tags.add(tag);
            }
        }

        return tags;
    }

    private String removeTrailingZeros(String value, boolean andDecimalPoint){
        char[] chars = value.toCharArray();

        if(value.indexOf(".") == -1)
            return value;
        
        int index = chars.length;
        char c = '0';
        
        while(index >= 0 && c == '0'){
            index--;
            c = chars[index];
        }

        if(andDecimalPoint && c == '.')
            index--;

        if(index < 0){
            return "";
        }
        else{
            return value.substring(0, index+1);
        }
    }

    private String removeLeadingZeros(String value, boolean andDecimalPoint){
        char[] chars = value.toCharArray();

        if(value.indexOf(".") == -1)
            return value;
        
        int index = -1;
        char c = '0';
        
        while(index < chars.length && c == '0'){
            index++;
            c = chars[index];
        }
        
        if(andDecimalPoint && c == '.')
            index++;

        if(index >= chars.length)
            return "";
        else
            return value.substring(index, chars.length);
    }
}
