/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package sealsync.ExcelParser;

import java.io.File;
import org.apache.poi.xssf.usermodel.*;

/**
 *
 * @author samuelgbeecher
 */
public class TagTypeExcelParser extends ExcelParser {
    public static final boolean DEBUG = false;

    public static final String TAG_TYPE_SHEET_NAME = "TagTypes";
    
    public static final int TYPE_NAME_COLUMN = 0;
    public static final int TYPE_DESCRIPTION_COLUMN = 1;
    public static final int TYPE_COLOR_START_COLUMN = 2;

    public static final String TYPE_ELEMENT = "TagType";
    public static final String TYPE_ATTRIBUTE_DESCRIPTION = "description";

    public static final String COLOR_ELEMENT = "Color";

    public static final String GENERAL_ATTRIBUTE_NAME = "name";
    
    private XSSFSheet types; 
    
    public TagTypeExcelParser(File workbookDir){
        super(workbookDir);
        types = workbook.getSheet(TAG_TYPE_SHEET_NAME);
    }

    public XmlElement parseExcelForTagTypes(){
        XmlElement sealTagTypes = new XmlElement("SealTagTypes");

        XSSFRow row;
        XSSFCell cell;

        int inc = 0;

        while(true){
            inc++;

            row = types.getRow(inc);
            if(row == null){
                if(DEBUG)
                    System.out.println("Found Empty Row. Done Parsing");

                break;
            }

            cell = row.getCell(TYPE_NAME_COLUMN);
            if(!cellIsValid(cell)){
                if(DEBUG)
                    System.out.println("Found Empty Cell At Type Name Column. Done Parsing");

                break;
            }

            XmlElement type = getType(row);
            sealTagTypes.addChild(type);

        }



        return sealTagTypes;
    }

    private XmlElement getType(XSSFRow row){
        XmlElement type = new XmlElement(TYPE_ELEMENT);
        XSSFCell cell = row.getCell(TYPE_NAME_COLUMN);

        String typeName = cell.getStringCellValue();
        type.putAttributeWithValue(GENERAL_ATTRIBUTE_NAME, typeName);

        cell = row.getCell(TYPE_DESCRIPTION_COLUMN);
        String typeDescription = cell.getStringCellValue();
        type.putAttributeWithValue(TYPE_ATTRIBUTE_DESCRIPTION, typeDescription);

        int inc = TYPE_COLOR_START_COLUMN - 1;
        while(true){
            inc++;

            cell = row.getCell(inc);

            if(!cellIsValid(cell)){
                break;
            }

            XmlElement color = new XmlElement(COLOR_ELEMENT);

            String colorName = cell.getStringCellValue();
            color.putAttributeWithValue(GENERAL_ATTRIBUTE_NAME, colorName);

            type.addChild(color);
        }

        return type;
    }

    private boolean cellIsValid(XSSFCell cell){
        boolean valid = cell != null && cell.getCellType() != XSSFCell.CELL_TYPE_BLANK;
        return valid;
    }

}
