/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package sealsync.ExcelParser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

/**
 *
 * @author samuelgbeecher
 */
public class XmlElement {
    private String elementName;
    private HashMap<String, String> attributes;
    private ArrayList<XmlElement> children;

    public XmlElement(String elementNameIn){
        elementName = elementNameIn;
        attributes = new HashMap<String, String>();
        children = null;
    }

    public String getElementName(){
        return elementName;
    }

    public void putAttributeWithValue(String attribute, String value){
        attributes.put(attribute, value);
    }

    public String getAttribute(String attribute){
        return attributes.get(attribute);
    }

    public void clearAttributes(){
        attributes = new HashMap<String, String>();
    }

    public void addChild(XmlElement child){
        if(children == null)
            children = new ArrayList<XmlElement>();

        children.add(child);
    }

    public boolean removeChild(XmlElement child){
        if(children == null)
            return false;

        return children.remove(child);
    }

    public void clearChildren(){
        children = null;
    }

    public ArrayList<XmlElement> getChildren(){
        return children;
    }

    public String openingTagWithAttributes(){
        String xml = "<"+elementName;

        Set<String> keys = attributes.keySet();

        for(Iterator<String> itr = keys.iterator(); itr.hasNext(); ){
            String attr = itr.next();
            xml += " "+attr+"=\""+attributes.get(attr)+"\"";
        }

        return xml + ">";
    }

    public String closingTag(){
       return "</"+elementName+">";
    }

    public String toXml(){
        String xml = "<"+elementName;

        Set<String> keys = attributes.keySet();

        for(Iterator<String> itr = keys.iterator(); itr.hasNext(); ){
            String attr = itr.next();
            xml += " "+attr+"=\""+attributes.get(attr)+"\"";
        }

        if(children == null){
            xml += "/>\n";
        }
        else{
            xml += ">\n";

            for(XmlElement child : children){
                xml += child.toXml() + "";
            }

            xml += "</"+elementName+">\n";
        }

        return xml;
    }

    /**
     * Provides a deep copy of the object
     * @return
     */
    public XmlElement clone(){
        XmlElement element = new XmlElement(elementName);

        if(children != null){
            for(XmlElement child : children)
                element.addChild(child.clone());
        }

        Set<String> keys = attributes.keySet();
        
        if(keys != null && keys.size() > 0){
            for(Iterator<String> itr = keys.iterator(); itr.hasNext(); ){
                String attr = itr.next();
                element.putAttributeWithValue(attr, getAttribute(attr));
            }
        }

        return element;

    }

}
