/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package sealsync;


import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.*;

/**
 *
 * @author samuelgbeecher
 */
public class MainMenu extends JFrame implements Runnable {
    public static final int WIDTH = 300;
    public static final int HEIGHT = 240;

    public static final String TITLE = "Seal Synker";

    private JPanel mainPanel;

    private SealExcelExport excelExport;
    private SealCSVImport csvImport;

    public MainMenu(){
        excelExport = new SealExcelExport();
        csvImport = new SealCSVImport();
    }

    private void setupUI(){
        setTitle(TITLE);
        setSize(WIDTH, HEIGHT);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setResizable(false);

        mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.Y_AXIS));
        add(mainPanel);

        JButton exportButton = new JButton("Export Seal Data");
        exportButton.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent ae) {
                startExport();
            }
        });
        mainPanel.add(exportButton);

        JButton importButton = new JButton("Import Seal CSV");
        importButton.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent ae) {
                startImport();
            }
        });
        mainPanel.add(importButton);

        JButton exitButton = new JButton("Exit");
        exitButton.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent ae) {
                exit();
            }
        });
        mainPanel.add(exitButton);
    }

    private void startExport(){
        excelExport.startExport();
    }

    private void startImport(){
        csvImport.startCSVImport();
    }

    private void exit(){
        System.exit(0);
    }

    public void run() {
        setupUI();
        setVisible(true);
    }
}
