/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package sealsync;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import javax.swing.JFileChooser;

/**
 *
 * @author samuelgbeecher
 */
public class SealCSVImport {
    public static final String ROOT_DIRECTORY = "/Android/data/org.me.sealproject/";
    public static final String CSV_FOLDER = "/csv";

    private File filePath;

    public boolean startCSVImport(){
        try{
            USBChooser myChooser = new USBChooser();
            filePath = myChooser.chooseUSB();

            File csvRootFile = new File(filePath.getAbsolutePath() + ROOT_DIRECTORY + CSV_FOLDER);

            Chooser chooser = new Chooser();
            chooser.setRoot(csvRootFile);
            File csv = chooser.chooseFile();

            if(csv == null)
                return false;

            // after choosing usb, must choose CSV file
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.showSaveDialog(null);

            File saveLocation = fileChooser.getSelectedFile();

            if(saveLocation == null)
                return false;

            saveLocation = new File(saveLocation.getAbsolutePath() + ".csv");

            //WARNING: Not deleting CSV After Transfer
            return transferFile(csv, saveLocation, false);
        } catch(Exception e){
            e.printStackTrace();
            return false;
        }
    }

    public boolean transferFile(File fileToTransfer, File locationToTransferTo, boolean deleteAfterwards){
        String contents = readFile(fileToTransfer);
        if(contents != null){
            if(writeFile(contents, locationToTransferTo)){
                //Success Message
                fileToTransfer.delete();
                return true;
            }
        }

        return false;

    }

    public String readFile(File fileToRead){
        String contents = null;

        try{
            InputStreamReader objIn = null;
            
            objIn = new InputStreamReader(new FileInputStream(fileToRead));
            
            char readChar = 0;
            contents = "";
            
            while((readChar = (char)objIn.read()) >= 0 && readChar < 65535){
                contents += readChar;
                System.out.print(readChar);
            }
        }
        catch(Exception e){
            contents = null;
            e.printStackTrace();
        }

        return contents;
    }

    public boolean writeFile(String contents, File location){
        boolean successful = true;
        
        try{
            OutputStreamWriter objOut = null;
            
            objOut = new OutputStreamWriter(new FileOutputStream(location), "UTF-8");
            
            objOut.write(contents);

            objOut.close();

            System.out.println("Done Writing File");
            successful = true;
        }
        catch(Exception e){
            successful = false;
            e.printStackTrace();
        }

        return successful;
    }
}
