/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package sealsync;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import javax.swing.JFileChooser;

import sealsync.ExcelParser.*;

/**
 *
 * @author samuelgbeecher
 */
public class SealExcelExport {
    public static final String ROOT_DIRECTORY = "/Android/data/org.me.sealproject/";
    public static final String XML_FOLDER = "sealXml/";
    public static final String DATA_FOLDER = "sealData/";

    public static final String SEALS_XML_FILE_NAME = "seals.xml";
    public static final String ISLANDS_XML_FILE_NAME = "islands.xml";
    public static final String CODES_XML_FILE_NAME = "codes.xml";
    public static final String TAG_TYPES_XML_FILE_NAME = "tagTypes.xml";

    private File filePath;

    private  ArrayList<XmlElement> seals;
    private  ArrayList<XmlElement> islands;
    private  ArrayList<XmlElement> codes;
    private  ArrayList<XmlElement> tagTypes;

    private boolean debug = false;

    public void startExport(){
        if(debug){
            System.out.println("Debugging Seal Excel Export");
        }

        try{
            USBChooser myChooser = new USBChooser();
            filePath = myChooser.chooseUSB();

            JFileChooser chooser = new JFileChooser();
            chooser.showOpenDialog(null);
            File excelSheet = chooser.getSelectedFile();

            if(excelSheet == null)
                return;

            boolean excelParsed = parseExcel(excelSheet);

            if(excelParsed){
                System.out.println("Excel Parsed");

                boolean xmlWritten = writeXml();

                if(xmlWritten){
                    System.out.println("Xml Written");
                }
                else{
                    System.out.println("Error writing Excel");
                }
            }
            else{
                System.out.println("Error parsing excel");
            }
        }
        catch(Exception e){
            System.out.println("Error");
            System.out.println(e);
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
    }

    private boolean parseExcel(File excelSheet){
        SealExcelParser sealIdParser = new SealExcelParser(excelSheet);
        IslandExcelParser islandParser = new IslandExcelParser(excelSheet);
        CodeExcelParser codeParser = new CodeExcelParser(excelSheet);
        TagTypeExcelParser tagTypeParser = new TagTypeExcelParser(excelSheet);

        seals = sealIdParser.parseExcelForSeals().getChildren();
        islands = islandParser.parseExcelForRookeries().getChildren();
        codes = codeParser.parseExcelForCodes().getChildren();
        tagTypes = tagTypeParser.parseExcelForTagTypes().getChildren();

        boolean successful = true;

        if(seals == null){
            successful = false;
            System.out.println("Failed to parse Seals");
        }

        if(islands == null){
            successful = false;
            System.out.println("Failed to parse Islands");
        }

        if(codes == null){
            successful = false;
            System.out.println("Failed to parse Codes");
        }

        if(tagTypes == null){
            successful = false;
            System.out.println("Failed to parse Tag Types");
        }

        return successful;
    }

    private boolean writeXml(){
        boolean successful = true;

        if(!writeSeals(seals)){
            System.out.println("Failed to write seals");
            successful = false;
        }


        if(!writeIslands(islands)){
            System.out.println("Failed to write Islands");
            successful = false;
        }

        if(!writeCodes(codes)){
            System.out.println("Failed to write code");
            successful = false;
        }

        if(!writeTagTypes(tagTypes)){
            System.out.println("Failed to write tag types");
            successful = false;
        }

        return successful;
    }

    private boolean writeSeals(ArrayList<XmlElement> seals){
        try{
            System.out.println("Writing Seals");

            OutputStreamWriter objOut = null;

            if(debug)
                objOut = new OutputStreamWriter(new FileOutputStream("/Users/samuelgbeecher/Desktop/" + SEALS_XML_FILE_NAME), "UTF-8");
            else
                objOut = new OutputStreamWriter(new FileOutputStream(filePath.getAbsolutePath() + ROOT_DIRECTORY + XML_FOLDER + SEALS_XML_FILE_NAME), "UTF-8");

            objOut.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<SEALXML>\n");

            for(int i = 0; i < seals.size(); i++){
                objOut.write(seals.get(i).toXml());

            }

            objOut.write("</SEALXML>");

            objOut.close();
            System.out.println("Done Writing Seals");
            return true;
        }
        catch(Exception e){
            return false;
        }
    }

    private boolean writeIslands(ArrayList<XmlElement> islands){
        try{
            System.out.println("Writing Islands");
            OutputStreamWriter objOut = null;

            if(debug)
                objOut = new OutputStreamWriter(new FileOutputStream("/Users/samuelgbeecher/Desktop/" + ISLANDS_XML_FILE_NAME), "UTF-8");
            else
                objOut = new OutputStreamWriter(new FileOutputStream(filePath.getAbsolutePath() + ROOT_DIRECTORY + XML_FOLDER + ISLANDS_XML_FILE_NAME), "UTF-8");

            objOut.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ISLANDXML>\n");

            for(int i = 0; i < islands.size(); i++){
                objOut.write(islands.get(i).toXml());
            }

            objOut.write("</ISLANDXML>");

            objOut.close();
            System.out.println("Done Writing Islands");
            return true;
        }
        catch(Exception e){
            return false;
        }
    }


    private boolean writeCodes(ArrayList<XmlElement> codes){
        try{
            System.out.println("Writing Codes");
            OutputStreamWriter objOut = null;

            if(debug)
                objOut = new OutputStreamWriter(new FileOutputStream("/Users/samuelgbeecher/Desktop/" + CODES_XML_FILE_NAME), "UTF-8");
            else
                objOut = new OutputStreamWriter(new FileOutputStream(filePath.getAbsolutePath() + ROOT_DIRECTORY + XML_FOLDER + CODES_XML_FILE_NAME), "UTF-8");


            objOut.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<CODEXML>\n");

            for(int i = 0; i < codes.size(); i++){
                objOut.write(codes.get(i).toXml());
            }

            objOut.write("</CODEXML>");

            objOut.close();
            System.out.println("Done Writing Codes");
            return true;
        }
        catch(Exception e){
            return false;
        }
    }

    private boolean writeTagTypes(ArrayList<XmlElement> tagTypes){
        try{
            System.out.println("Writing Tag Types");
            OutputStreamWriter objOut = null;

            if(debug)
                objOut = new OutputStreamWriter(new FileOutputStream("/Users/samuelgbeecher/Desktop/" + TAG_TYPES_XML_FILE_NAME), "UTF-8");
            else
                objOut = new OutputStreamWriter(new FileOutputStream(filePath.getAbsolutePath() + ROOT_DIRECTORY + XML_FOLDER + TAG_TYPES_XML_FILE_NAME), "UTF-8");

            objOut.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<TAGTYPEXML>\n");

            for(int i = 0; i < tagTypes.size(); i++){
                objOut.write(tagTypes.get(i).toXml());
            }

            objOut.write("</TAGTYPEXML>");

            objOut.close();
            System.out.println("Done Writing Tag Types");
            return true;
        }
        catch(Exception e){
            return false;
        }
    }
}
